/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.conditions;

import java.util.Iterator;
import java.util.Objects;
import org.cornutum.tcases.conditions.AllOf;
import org.cornutum.tcases.conditions.BoundedAssertion;
import org.cornutum.tcases.conditions.ConditionSet;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.conditions.IConditionVisitor;
import org.cornutum.tcases.util.ToString;

public class Between
extends AllOf {
    public Between(BoundedAssertion min, BoundedAssertion max) {
        super(new ICondition[0]);
        if (!Objects.equals(min.getProperty(), max.getProperty())) {
            throw new IllegalArgumentException(String.format("min property=%s not the same as max property=%s", min.getProperty(), max.getProperty()));
        }
        if (!min.completable()) {
            throw new IllegalArgumentException(String.format("min=%s is not a lower bound", min));
        }
        if (max.completable()) {
            throw new IllegalArgumentException(String.format("max=%s is not an upper bound", max));
        }
        this.conditions_.add(min);
        this.conditions_.add(max);
    }

    public BoundedAssertion getMin() {
        ICondition min = null;
        Iterator<ICondition> conditions = this.getConditions();
        for (int i = 0; i < 1; ++i) {
            min = conditions.next();
        }
        return (BoundedAssertion)min;
    }

    public BoundedAssertion getMax() {
        ICondition max = null;
        Iterator<ICondition> conditions = this.getConditions();
        for (int i = 0; i < 2; ++i) {
            max = conditions.next();
        }
        return (BoundedAssertion)max;
    }

    @Override
    public ConditionSet add(ICondition condition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConditionSet remove(ICondition condition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(IConditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return ToString.getBuilder(this).append("min", (Object)this.getMin()).append("max", (Object)this.getMax()).toString();
    }
}

