/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.anon;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarDefBuilder;
import org.cornutum.tcases.VarDefIterator;
import org.cornutum.tcases.VarSet;
import org.cornutum.tcases.VarSetBuilder;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.VarValueDefBuilder;
import org.cornutum.tcases.conditions.AllOf;
import org.cornutum.tcases.conditions.AnyOf;
import org.cornutum.tcases.conditions.AssertLess;
import org.cornutum.tcases.conditions.AssertMore;
import org.cornutum.tcases.conditions.AssertNotLess;
import org.cornutum.tcases.conditions.AssertNotMore;
import org.cornutum.tcases.conditions.Between;
import org.cornutum.tcases.conditions.BoundedAssertion;
import org.cornutum.tcases.conditions.Conditions;
import org.cornutum.tcases.conditions.ContainsAll;
import org.cornutum.tcases.conditions.ContainsAny;
import org.cornutum.tcases.conditions.Equals;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.conditions.IConditionVisitor;
import org.cornutum.tcases.conditions.IConjunct;
import org.cornutum.tcases.conditions.Not;
import org.cornutum.tcases.generator.GeneratorSet;
import org.cornutum.tcases.generator.IGeneratorSet;
import org.cornutum.tcases.generator.TupleCombiner;
import org.cornutum.tcases.generator.TupleGenerator;
import org.cornutum.tcases.generator.TupleRef;
import org.cornutum.tcases.util.CollectionUtils;

public class Anonymizer {
    private final SystemDictionary dictionary_;
    private final SystemInputDef anonDef_;

    public Anonymizer(SystemInputDef inputDef) {
        this.dictionary_ = new SystemDictionary(inputDef);
        this.anonDef_ = this.anonymize(inputDef);
    }

    public SystemInputDef getInputDef() {
        return this.anonDef_;
    }

    private SystemInputDef anonymize(SystemInputDef inputDef) {
        SystemInputDef anonDef = new SystemInputDef(this.dictionary_.getAnonSystem());
        CollectionUtils.toStream(inputDef.getFunctionInputDefs()).map(f -> this.anonymize(this.dictionary_.getDictForFunction(f.getName()), (FunctionInputDef)f)).forEach(f -> anonDef.addFunctionInputDef((FunctionInputDef)f));
        return anonDef;
    }

    private FunctionInputDef anonymize(FunctionDictionary dictionary, FunctionInputDef inputDef) {
        FunctionInputDef anonDef = new FunctionInputDef(dictionary.getAnonFunction());
        this.anonymizeVars(dictionary, inputDef, anonDef);
        this.anonymizeValues(dictionary, inputDef, anonDef);
        return anonDef;
    }

    private void anonymizeVars(FunctionDictionary dictionary, FunctionInputDef inputDef, FunctionInputDef anonDef) {
        CollectionUtils.toStream(new VarDefIterator(inputDef)).forEach(varDef -> this.anonymizeVar(dictionary, anonDef, (IVarDef)varDef));
    }

    private IVarDef anonymizeVar(FunctionDictionary dictionary, FunctionInputDef anonDef, IVarDef var) {
        String anonVarPath = dictionary.getAnonForVarPath(var.getPathName());
        IVarDef anonVar = anonDef.findVarPath(anonVarPath);
        if (anonVar == null) {
            String anonName = Optional.of(DefUtils.toPath(anonVarPath)).map(path -> path[((String[])path).length - 1]).get();
            anonVar = var.getMembers() == null ? VarDefBuilder.with(anonName).type(var.getType()).when(ConditionAnonymizer.anonymize(dictionary, var.getCondition())).build() : VarSetBuilder.with(anonName).type(var.getType()).when(ConditionAnonymizer.anonymize(dictionary, var.getCondition())).build();
            IVarDef parent = var.getParent();
            if (parent == null) {
                anonDef.addVarDef(anonVar);
            } else {
                VarSet anonParent = (VarSet)this.anonymizeVar(dictionary, anonDef, parent);
                anonParent.addMember(anonVar);
            }
        }
        return anonVar;
    }

    private void anonymizeValues(FunctionDictionary dictionary, FunctionInputDef inputDef, FunctionInputDef anonDef) {
        CollectionUtils.toStream(new VarDefIterator(inputDef)).forEach(varDef -> this.anonymizeValues(dictionary, inputDef, anonDef, (VarDef)varDef));
    }

    private void anonymizeValues(FunctionDictionary dictionary, FunctionInputDef inputDef, FunctionInputDef anonDef, VarDef varDef) {
        String varPath = varDef.getPathName();
        String anonVarPath = dictionary.getAnonForVarPath(varPath);
        VarDef anonVar = anonDef.findVarDefPath(anonVarPath);
        CollectionUtils.toStream(varDef.getValues()).forEach(value -> anonVar.addValue(VarValueDefBuilder.with(dictionary.getAnonForValue(varPath, value.getName())).type(value.getType()).when(ConditionAnonymizer.anonymize(dictionary, value.getCondition())).properties(CollectionUtils.toStream(value.getProperties()).map(p -> dictionary.getAnonForProperty((String)p)).collect(Collectors.toList())).build()));
    }

    public IGeneratorSet anonymize(IGeneratorSet genDef) {
        GeneratorSet anonDef = new GeneratorSet();
        Arrays.stream(genDef.getGeneratorFunctions()).forEach(f -> {
            FunctionDictionary functionDict = this.dictionary_.getDictForFunction((String)f);
            anonDef.addGenerator(functionDict.getAnonFunction(), this.anonymize(functionDict, (TupleGenerator)genDef.getGenerator((String)f)));
        });
        return anonDef;
    }

    private TupleGenerator anonymize(FunctionDictionary dictionary, TupleGenerator tupleGen) {
        TupleGenerator anonGen = new TupleGenerator();
        anonGen.setDefaultTupleSize(tupleGen.getDefaultTupleSize());
        anonGen.setRandomSeed(tupleGen.getRandomSeed());
        anonGen.setCombiners(tupleGen.getCombiners().stream().map(c -> this.anonymize(dictionary, (TupleCombiner)c)).collect(Collectors.toList()));
        return anonGen;
    }

    private TupleCombiner anonymize(FunctionDictionary dictionary, TupleCombiner tupleCombiner) {
        TupleCombiner anonCombiner = new TupleCombiner();
        anonCombiner.setTupleSize(tupleCombiner.getTupleSize());
        Arrays.stream(tupleCombiner.getIncluded()).forEach(varRef -> anonCombiner.addIncludedVar(this.anonymizeVarRef(dictionary, (String)varRef)));
        Arrays.stream(tupleCombiner.getExcluded()).forEach(varRef -> anonCombiner.addExcludedVar(this.anonymizeVarRef(dictionary, (String)varRef)));
        CollectionUtils.toStream(tupleCombiner.getOnceTuples()).forEach(tupleRef -> anonCombiner.addOnceTuple(this.anonymizeTupleRef(dictionary, (TupleRef)tupleRef)));
        return anonCombiner;
    }

    private String anonymizeVarRef(FunctionDictionary dictionary, String varRef) {
        int wildcardStart = varRef.lastIndexOf(".*");
        String varPath = wildcardStart >= 0 ? varRef.substring(0, wildcardStart) : varRef;
        String wildcard = wildcardStart >= 0 ? varRef.substring(wildcardStart) : "";
        return String.format("%s%s", dictionary.getAnonForVarPath(varPath), wildcard);
    }

    private TupleRef anonymizeTupleRef(FunctionDictionary dictionary, TupleRef tupleRef) {
        TupleRef anonRef = new TupleRef();
        CollectionUtils.toStream(tupleRef.getVarBindings()).map(binding -> {
            String anonVar = dictionary.getAnonForVarPath(binding.getVar());
            return new VarBinding(anonVar, dictionary.getAnonForValue(binding.getVar(), binding.getValue()));
        }).forEach(binding -> anonRef.addVarBinding((VarBinding)binding));
        return anonRef;
    }

    private static class ConditionAnonymizer
    implements IConditionVisitor {
        private FunctionDictionary dictionary_;
        private ICondition anonCondition_;

        public static ICondition anonymize(FunctionDictionary dictionary, ICondition condition) {
            ICondition anonCondition = null;
            if (condition != null) {
                ConditionAnonymizer anonymizer = new ConditionAnonymizer(dictionary);
                condition.accept(anonymizer);
                anonCondition = anonymizer.anonCondition_;
            }
            return anonCondition;
        }

        public ConditionAnonymizer(FunctionDictionary dictionary) {
            this.dictionary_ = dictionary;
        }

        @Override
        public void visit(AllOf condition) {
            this.anonCondition_ = Conditions.allOf((ICondition[])CollectionUtils.toStream(condition.getConditions()).map(c -> ConditionAnonymizer.anonymize(this.dictionary_, c)).toArray(ICondition[]::new));
        }

        @Override
        public void visit(AnyOf condition) {
            this.anonCondition_ = Conditions.anyOf((ICondition[])CollectionUtils.toStream(condition.getConditions()).map(c -> ConditionAnonymizer.anonymize(this.dictionary_, c)).toArray(ICondition[]::new));
        }

        @Override
        public void visit(ContainsAll condition) {
            this.anonCondition_ = Conditions.has((String[])CollectionUtils.toStream(condition.getProperties()).map(p -> this.dictionary_.getAnonForProperty((String)p)).toArray(String[]::new));
        }

        @Override
        public void visit(ContainsAny condition) {
            this.anonCondition_ = Conditions.hasAny((String[])CollectionUtils.toStream(condition.getProperties()).map(p -> this.dictionary_.getAnonForProperty((String)p)).toArray(String[]::new));
        }

        @Override
        public void visit(IConjunct condition) {
        }

        @Override
        public void visit(Not condition) {
            this.anonCondition_ = Conditions.not((ICondition[])CollectionUtils.toStream(condition.getConditions()).map(c -> ConditionAnonymizer.anonymize(this.dictionary_, c)).toArray(ICondition[]::new));
        }

        @Override
        public void visit(AssertLess condition) {
            this.anonCondition_ = Conditions.lessThan(this.dictionary_.getAnonForProperty(condition.getProperty()), condition.getBound());
        }

        @Override
        public void visit(AssertMore condition) {
            this.anonCondition_ = Conditions.moreThan(this.dictionary_.getAnonForProperty(condition.getProperty()), condition.getBound());
        }

        @Override
        public void visit(AssertNotLess condition) {
            this.anonCondition_ = Conditions.notLessThan(this.dictionary_.getAnonForProperty(condition.getProperty()), condition.getBound());
        }

        @Override
        public void visit(AssertNotMore condition) {
            this.anonCondition_ = Conditions.notMoreThan(this.dictionary_.getAnonForProperty(condition.getProperty()), condition.getBound());
        }

        @Override
        public void visit(Between condition) {
            this.anonCondition_ = new Between((BoundedAssertion)ConditionAnonymizer.anonymize(this.dictionary_, condition.getMin()), (BoundedAssertion)ConditionAnonymizer.anonymize(this.dictionary_, condition.getMax()));
        }

        @Override
        public void visit(Equals condition) {
            this.anonCondition_ = Conditions.equalTo(this.dictionary_.getAnonForProperty(condition.getMin().getProperty()), condition.getMin().getBound());
        }
    }

    private static class FunctionDictionary {
        private final String anonFunction_;
        private Map<String, String> varPathToAnon_ = new HashMap<String, String>();
        private Map<String, Map<Object, Object>> varPathValuesToAnon_ = new HashMap<String, Map<Object, Object>>();
        private Map<String, String> propertyToAnon_ = new HashMap<String, String>();

        public FunctionDictionary(String anonFunction, FunctionInputDef inputDef) {
            this.anonFunction_ = anonFunction;
            this.createVarNames(inputDef);
            this.createValueNames(inputDef);
            this.createPropertyNames(inputDef);
        }

        public FunctionDictionary(String anonFunction, FunctionDictionary other) {
            this.anonFunction_ = anonFunction;
            this.varPathToAnon_ = other.varPathToAnon_;
            this.varPathValuesToAnon_ = other.varPathValuesToAnon_;
            this.propertyToAnon_ = other.propertyToAnon_;
        }

        private void createVarNames(FunctionInputDef inputDef) {
            this.renameVars(inputDef.getVarDefs());
        }

        private void renameVars(Iterator<IVarDef> varDefs) {
            int i = 0;
            while (varDefs.hasNext()) {
                IVarDef varDef = varDefs.next();
                IVarDef parent = varDef.getParent();
                String anonParentPath = Optional.ofNullable(parent).map(p -> this.getAnonForVarPath(p.getPathName())).orElse(null);
                String anonParentName = Optional.ofNullable(DefUtils.toPath(anonParentPath)).map(path -> path[((String[])path).length - 1]).orElse(null);
                String anonPath = Optional.ofNullable(anonParentPath).map(path -> String.format("%s.", path)).orElse("");
                String anonPrefix = Optional.ofNullable(anonParentName).orElse("V");
                String anon = String.format("%s%s-%s", anonPath, anonPrefix, i);
                this.varPathToAnon_.put(varDef.getPathName(), anon);
                Optional.ofNullable(varDef.getMembers()).ifPresent(members -> this.renameVars((Iterator<IVarDef>)members));
                ++i;
            }
        }

        private void createValueNames(FunctionInputDef inputDef) {
            CollectionUtils.toStream(new VarDefIterator(inputDef)).forEach(varDef -> {
                String anonVarPath = this.getAnonForVarPath(varDef.getPathName());
                String anonValueTag = Optional.of(DefUtils.toPath(anonVarPath)).map(path -> path[((String[])path).length - 1]).map(name -> name.replaceAll("V", "L")).get();
                Iterator<VarValueDef> values = varDef.getValues();
                HashMap<Object, Object> anonValues = new HashMap<Object, Object>();
                int i = 0;
                while (values.hasNext()) {
                    VarValueDef value = values.next();
                    Object valueName = value.getName();
                    Object anonValueName = valueName == null || valueName instanceof Number || valueName instanceof Boolean ? valueName : String.format("%s_%s", anonValueTag, i);
                    anonValues.put(valueName, anonValueName);
                    ++i;
                }
                this.varPathValuesToAnon_.put(varDef.getPathName(), anonValues);
            });
        }

        private void createPropertyNames(FunctionInputDef inputDef) {
            String[] properties = CollectionUtils.toStream(new VarDefIterator(inputDef)).flatMap(varDef -> CollectionUtils.toStream(varDef.getValues())).flatMap(valueDef -> CollectionUtils.toStream(valueDef.getProperties().iterator()).sorted()).collect(Collectors.toCollection(LinkedHashSet::new)).toArray(new String[0]);
            int maxLen = String.valueOf(properties.length).length();
            for (int i = 0; i < properties.length; ++i) {
                this.propertyToAnon_.put(properties[i], String.format("P-%s", StringUtils.leftPad((String)String.valueOf(i), (int)maxLen, (char)'0')));
            }
        }

        public String getAnonFunction() {
            return this.anonFunction_;
        }

        public String getAnonForVarPath(String varPath) {
            return this.varPathToAnon_.get(varPath);
        }

        public Object getAnonForValue(String varPath, Object value) {
            return this.varPathValuesToAnon_.get(varPath).get(value);
        }

        public String getAnonForProperty(String property) {
            return this.propertyToAnon_.get(property);
        }
    }

    private static class SystemDictionary {
        private final String anonSystem_;
        private final Map<String, FunctionDictionary> functionToDict_ = new HashMap<String, FunctionDictionary>();

        public SystemDictionary(SystemInputDef inputDef) {
            this.anonSystem_ = "S";
            Iterator<FunctionInputDef> functionDefs = inputDef.getFunctionInputDefs();
            int i = 0;
            while (functionDefs.hasNext()) {
                FunctionInputDef functionDef = functionDefs.next();
                String anonFunction = String.format("F%s", i);
                this.functionToDict_.put(functionDef.getName(), new FunctionDictionary(anonFunction, functionDef));
                ++i;
            }
        }

        public String getAnonSystem() {
            return this.anonSystem_;
        }

        public FunctionDictionary getDictForFunction(String function) {
            FunctionDictionary dictionary;
            if (!"*".equals(function)) {
                dictionary = this.functionToDict_.get(function);
            } else {
                if (this.functionToDict_.size() != 1) {
                    throw new IllegalStateException(String.format("%s functions associated with generator=%s", this.functionToDict_.size(), function));
                }
                dictionary = new FunctionDictionary("*", this.functionToDict_.values().iterator().next());
            }
            return dictionary;
        }
    }
}

