/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.cornutum.tcases.Conditional;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.util.ObjectUtils;
import org.cornutum.tcases.util.ToString;

public class VarValueDef
extends Conditional {
    private Object name_;
    private Type type_;
    private Set<String> properties_;

    public VarValueDef() {
        this(null);
    }

    public VarValueDef(Object name) {
        this(name, Type.VALID);
    }

    public VarValueDef(Object name, Type type) {
        this.setName(name);
        this.setType(type);
        this.setProperties(null);
    }

    public void setName(Object name) {
        DefUtils.assertVarValue(name);
        this.name_ = name;
    }

    public Object getName() {
        return this.name_;
    }

    public Object getExternalName() {
        return ObjectUtils.toExternalObject(this.getName());
    }

    public void setType(Type type) {
        this.type_ = type;
    }

    public Type getType() {
        return this.type_;
    }

    public boolean isValid() {
        return this.getType().isValid();
    }

    public boolean hasProperty(String property) {
        return this.properties_.contains(property);
    }

    public boolean hasProperties() {
        return !this.properties_.isEmpty();
    }

    public void setProperties(Collection<String> properties) {
        this.properties_ = new HashSet<String>();
        this.addProperties(properties);
    }

    public Iterable<String> getProperties() {
        return this.properties_;
    }

    public VarValueDef addProperties(Collection<String> properties) {
        if (properties != null) {
            DefUtils.assertPropertyIdentifiers(properties);
            this.properties_.addAll(properties);
        }
        return this;
    }

    public VarValueDef addProperties(String ... properties) {
        return this.addProperties(Arrays.asList(properties));
    }

    public VarValueDef removeProperties(Collection<String> properties) {
        if (properties != null) {
            this.properties_.removeAll(properties);
        }
        return this;
    }

    public VarValueDef removeProperties(String ... properties) {
        return this.removeProperties(Arrays.asList(properties));
    }

    public boolean equals(Object object) {
        VarValueDef other = object != null && object.getClass().equals(this.getClass()) ? (VarValueDef)object : null;
        return other != null && Objects.equals(other.getExternalName(), this.getExternalName()) && Objects.equals((Object)other.getType(), (Object)this.getType());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getExternalName()) ^ Objects.hashCode((Object)this.getType());
    }

    public String toString() {
        return ToString.getBuilder(this).append(this.getName()).toString();
    }

    public boolean isNA() {
        return false;
    }

    public static enum Type {
        VALID(true),
        FAILURE(false),
        ONCE(true);

        private final boolean valid_;

        private Type(boolean valid) {
            this.valid_ = valid;
        }

        public boolean isValid() {
            return this.valid_;
        }
    }
}

