/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.AnnotatedBuilder;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarDefBuilder;
import org.cornutum.tcases.VarSet;
import org.cornutum.tcases.conditions.ICondition;

public class VarSetBuilder
extends AnnotatedBuilder<VarSetBuilder> {
    VarSet varSet_;

    public static VarSetBuilder with(String name) {
        return new VarSetBuilder().name(name);
    }

    public static VarSetBuilder with(VarSet varSet) {
        return new VarSetBuilder(varSet);
    }

    public VarSetBuilder() {
        this(null);
    }

    public VarSetBuilder(VarSet varSet) {
        this.start(varSet);
    }

    public VarSet build() {
        return this.varSet_;
    }

    public VarSetBuilder start() {
        return this.start(null);
    }

    public VarSetBuilder start(VarSet varSet) {
        this.varSet_ = varSet == null ? new VarSet("V") : varSet;
        return this;
    }

    public VarSetBuilder name(String name) {
        this.varSet_.setName(name);
        return this;
    }

    public VarSetBuilder type(String type) {
        this.varSet_.setType(type);
        return this;
    }

    public VarSetBuilder when(ICondition condition) {
        this.varSet_.setCondition(condition);
        return this;
    }

    public VarSetBuilder when(Optional<ICondition> condition) {
        condition.ifPresent(c -> this.when((ICondition)c));
        return this;
    }

    public VarSetBuilder members(IVarDef ... members) {
        for (IVarDef member : members) {
            this.varSet_.addMember(member);
        }
        return this;
    }

    public VarSetBuilder members(Iterable<IVarDef> members) {
        for (IVarDef member : members) {
            this.varSet_.addMember(member);
        }
        return this;
    }

    public VarSetBuilder members(Stream<IVarDef> members) {
        members.forEach(member -> this.varSet_.addMember((IVarDef)member));
        return this;
    }

    public VarSetBuilder varSetAtPath(String pathName) {
        return this.varSetAtPath(DefUtils.toPath(pathName));
    }

    public VarSetBuilder varSetAtPath(String[] path) {
        VarSet varSet = null;
        if (path != null && path.length > 0) {
            varSet = new VarSet(path[0]);
            this.varSet_.addMember(varSet);
            for (int i = 1; i < path.length; ++i) {
                VarSet child = new VarSet(path[i]);
                varSet.addMember(child);
                varSet = child;
            }
        }
        return varSet == null ? null : new VarSetBuilder(varSet);
    }

    public VarDefBuilder varDefAtPath(String pathName) {
        return this.varDefAtPath(DefUtils.toPath(pathName));
    }

    public VarDefBuilder varDefAtPath(String[] path) {
        VarDefBuilder varDefBuilder = null;
        if (path != null && path.length > 0) {
            String varDefName = path[path.length - 1];
            VarSetBuilder parentBuilder = this.varSetAtPath(Arrays.copyOfRange(path, 0, path.length - 1));
            if (parentBuilder != null) {
                varDefBuilder = parentBuilder.varDefAtPath(varDefName);
            } else {
                VarDef varDef = new VarDef(varDefName);
                this.varSet_.addMember(varDef);
                varDefBuilder = new VarDefBuilder(varDef);
            }
        }
        return varDefBuilder;
    }

    @Override
    protected Annotated getAnnotated() {
        return this.varSet_;
    }
}

