/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.AbstractVarDef;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.conditions.ICondition;

public class VarSet
extends AbstractVarDef {
    private List<IVarDef> members_ = new ArrayList<IVarDef>();

    public VarSet() {
        this(null);
    }

    public VarSet(String name) {
        super(name);
    }

    @Override
    public Iterator<IVarDef> getMembers() {
        return this.members_.iterator();
    }

    @Override
    public Iterator<VarValueDef> getValues() {
        return null;
    }

    @Override
    public void setParent(IVarDef parent) {
        super.setParent(parent);
        if (this.members_ != null) {
            for (IVarDef member : this.members_) {
                member.setParent(this);
            }
        }
    }

    @Override
    public void setCondition(ICondition condition) {
        super.setCondition(condition);
        if (this.members_ != null) {
            for (IVarDef member : this.members_) {
                member.setParent(this);
            }
        }
    }

    @Override
    public IVarDef find(String ... path) {
        return path == null || path.length == 0 ? this : this.getDescendant(path);
    }

    public VarSet addMember(IVarDef var) {
        assert (var != null);
        assert (var.getName() != null);
        if (this.findMember(var.getName()) >= 0) {
            throw new IllegalStateException("Member=" + var.getName() + " already defined for varSet=" + this.getPathName());
        }
        this.members_.add(var);
        var.setParent(this);
        var.setSeqNum(this.getNextSeqNum());
        return this;
    }

    public VarSet removeMember(String name) {
        int i = this.findMember(name);
        if (i >= 0) {
            this.members_.remove(i).setParent(null);
        }
        return this;
    }

    public IVarDef getMember(String name) {
        int i = this.findMember(name);
        return i >= 0 ? this.members_.get(i) : null;
    }

    public IVarDef getDescendant(String pathName) {
        return this.getDescendant(DefUtils.toPath(pathName));
    }

    private IVarDef getDescendant(String[] path) {
        int i;
        int pathLength = path == null ? 0 : path.length;
        int parentPathLength = pathLength - 1;
        VarSet parent = this;
        IVarDef descendant = null;
        for (i = 0; i < parentPathLength && (descendant = parent.getMember(StringUtils.trimToNull((String)path[i]))) != null && descendant.getClass().equals(this.getClass()); ++i) {
            parent = (VarSet)descendant;
        }
        return i == parentPathLength ? parent.getMember(StringUtils.trimToNull((String)path[i])) : null;
    }

    protected int findMember(String name) {
        int i;
        int memberCount = name == null ? 0 : this.members_.size();
        for (i = 0; i < memberCount && !name.equals(this.members_.get(i).getName()); ++i) {
        }
        return i < memberCount ? i : -1;
    }
}

