/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarNaBinding;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.util.ObjectUtils;
import org.cornutum.tcases.util.ToString;

public class VarBinding
extends Annotated
implements Comparable<VarBinding> {
    private String var_;
    private String varType_;
    private Object value_;
    private boolean valueValid_;
    private IVarDef varDef_;

    public VarBinding() {
        this(null, null, null);
    }

    public VarBinding(String varName, Object valueName) {
        this(varName, "arg", valueName);
    }

    public VarBinding(String varName, String varType, Object valueName) {
        this.setVar(varName);
        this.setType(varType);
        this.setValue(valueName);
        this.setValueValid(true);
    }

    public static VarBinding create(IVarDef varDef, VarValueDef valueDef) {
        VarBinding binding = valueDef.isNA() ? new VarNaBinding(varDef.getPathName(), varDef.getType()) : new VarBinding(varDef.getPathName(), varDef.getType(), valueDef.getName());
        binding.setValueValid(valueDef.isValid());
        binding.setVarDef(varDef);
        return binding;
    }

    public static VarBinding create(VarBindingDef def) {
        return VarBinding.create(def.getVarDef(), def.getValueDef());
    }

    public void setVar(String varName) {
        DefUtils.assertPath(varName);
        this.var_ = varName;
    }

    public String getVar() {
        return this.var_;
    }

    public void setValue(Object valueName) {
        DefUtils.assertVarValue(valueName);
        this.value_ = valueName;
    }

    public Object getValue() {
        return this.value_;
    }

    public Object getExternalValue() {
        return ObjectUtils.toExternalObject(this.getValue());
    }

    public void setType(String type) {
        DefUtils.assertIdentifier(type);
        this.varType_ = type;
    }

    public String getType() {
        return this.varType_;
    }

    public void setValueValid(boolean valid) {
        this.valueValid_ = valid;
    }

    public boolean isValueValid() {
        return this.valueValid_;
    }

    public boolean isValueNA() {
        return false;
    }

    private void setVarDef(IVarDef varDef) {
        this.varDef_ = varDef;
    }

    private IVarDef getVarDef() {
        return this.varDef_;
    }

    public String toString() {
        ToStringBuilder builder = ToString.getBuilder(this);
        builder.getStringBuffer().append(this.getVar()).append('=').append(this.getValue());
        if (!this.isValueValid()) {
            builder.getStringBuffer().append(",valid=").append(this.isValueValid());
        }
        return builder.toString();
    }

    @Override
    public int compareTo(VarBinding other) {
        IVarDef varDef = this.getVarDef();
        IVarDef otherVarDef = other.getVarDef();
        return varDef != null && otherVarDef != null ? varDef.getPosition().compareTo(otherVarDef.getPosition()) : (varDef != null ? 1 : (otherVarDef != null ? -1 : this.getVar().compareTo(other.getVar())));
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getVar());
    }

    public boolean equals(Object object) {
        VarBinding other = object != null && object.getClass().equals(this.getClass()) ? (VarBinding)object : null;
        return other != null && Objects.equals(this.getVar(), other.getVar());
    }
}

