/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.stream.Stream;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.AnnotatedBuilder;
import org.cornutum.tcases.TestCase;
import org.cornutum.tcases.VarBinding;

public class TestCaseBuilder
extends AnnotatedBuilder<TestCaseBuilder> {
    TestCase testCase_;

    public static TestCaseBuilder with(int id) {
        return new TestCaseBuilder().id(id);
    }

    public static TestCaseBuilder with(TestCase testCase) {
        return new TestCaseBuilder(testCase);
    }

    public TestCaseBuilder() {
        this.start();
    }

    public TestCaseBuilder(TestCase testCase) {
        this.start(testCase);
    }

    public TestCase build() {
        return this.testCase_;
    }

    public TestCaseBuilder start() {
        return this.start(null);
    }

    public TestCaseBuilder start(TestCase testCase) {
        this.testCase_ = testCase == null ? new TestCase(0) : testCase;
        return this;
    }

    public TestCaseBuilder id(int id) {
        this.testCase_.setId(id);
        return this;
    }

    public TestCaseBuilder name(String name) {
        this.testCase_.setName(name);
        return this;
    }

    public TestCaseBuilder bind(VarBinding ... bindings) {
        for (VarBinding binding : bindings) {
            this.testCase_.addVarBinding(binding);
        }
        return this;
    }

    public TestCaseBuilder bind(Iterable<VarBinding> bindings) {
        for (VarBinding binding : bindings) {
            this.testCase_.addVarBinding(binding);
        }
        return this;
    }

    public TestCaseBuilder bind(Stream<VarBinding> bindings) {
        bindings.forEach(binding -> this.testCase_.addVarBinding((VarBinding)binding));
        return this;
    }

    public TestCaseBuilder bind(String type, VarBinding ... bindings) {
        for (VarBinding binding : bindings) {
            binding.setType(type);
            this.testCase_.addVarBinding(binding);
        }
        return this;
    }

    @Override
    protected Annotated getAnnotated() {
        return this.testCase_;
    }
}

