/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.util.ToString;

public class TestCase
extends Annotated
implements Comparable<TestCase> {
    private int id_;
    private String name_;
    private List<VarBinding> varBindings_ = new ArrayList<VarBinding>();

    public TestCase(int id) {
        this.setId(id);
    }

    protected void setId(int id) {
        this.id_ = id;
    }

    public int getId() {
        return this.id_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public Type getType() {
        return this.getInvalidValue() != null ? Type.FAILURE : Type.SUCCESS;
    }

    public TestCase addVarBinding(VarBinding varBinding) {
        assert (varBinding != null);
        assert (varBinding.getVar() != null);
        String varName = varBinding.getVar();
        if (this.findBinding(varName) >= 0) {
            throw new IllegalStateException("Binding for " + varName + " already defined for testCase=" + this.getId());
        }
        this.varBindings_.add(varBinding);
        return this;
    }

    public TestCase removeVarBinding(String name) {
        int i = this.findBinding(name);
        if (i >= 0) {
            this.varBindings_.remove(i);
        }
        return this;
    }

    public VarBinding getVarBinding(String name) {
        int i = this.findBinding(name);
        return i >= 0 ? this.varBindings_.get(i) : null;
    }

    public VarBinding getInvalidValue() {
        VarBinding invalidBinding2 = null;
        for (VarBinding invalidBinding2 : this.varBindings_) {
            if (!invalidBinding2.isValueValid()) break;
            invalidBinding2 = null;
        }
        return invalidBinding2;
    }

    public Iterator<VarBinding> getVarBindings() {
        return this.varBindings_.iterator();
    }

    public Iterator<VarBinding> getVarBindings(String type) {
        return IteratorUtils.filteredIterator(this.varBindings_.iterator(), binding -> Objects.equals(binding.getType(), type));
    }

    private int findBinding(String name) {
        return IterableUtils.indexOf(this.varBindings_, binding -> Objects.equals(binding.getVar(), name));
    }

    public String[] getVarTypes() {
        TreeSet<String> typeSet = new TreeSet<String>();
        Iterator<VarBinding> vars = this.getVarBindings();
        while (vars.hasNext()) {
            typeSet.add(vars.next().getType());
        }
        String[] types = new String[typeSet.size()];
        typeSet.toArray(types);
        return types;
    }

    public String toString() {
        Object[] bindings = new VarBinding[this.varBindings_.size()];
        Arrays.sort(this.varBindings_.toArray(bindings));
        return ToString.getBuilder(this).append(this.getId()).append((Object)this.getName()).append((Object)this.getType()).append(bindings).toString();
    }

    @Override
    public int compareTo(TestCase other) {
        return this.getId() - other.getId();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.id_;
    }

    public boolean equals(Object object) {
        TestCase other = object != null && object.getClass().equals(this.getClass()) ? (TestCase)object : null;
        return other != null && this.id_ == other.id_;
    }

    public static enum Type {
        SUCCESS,
        FAILURE;

    }
}

