/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Iterator;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.FunctionTestDef;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.SystemTestDef;
import org.cornutum.tcases.TestCase;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.generator.GeneratorOptions;
import org.cornutum.tcases.generator.GeneratorSet;
import org.cornutum.tcases.generator.IGeneratorSet;
import org.cornutum.tcases.generator.ITestCaseGenerator;
import org.cornutum.tcases.generator.TupleGenerator;

public class Tcases {
    private Tcases() {
    }

    public static SystemTestDef getTests(SystemInputDef inputDef, IGeneratorSet genDef, SystemTestDef baseDef, GeneratorOptions options) {
        if (genDef == null) {
            genDef = GeneratorSet.basicGenerator();
        }
        SystemTestDef testDef = new SystemTestDef(inputDef.getName());
        Iterator<FunctionInputDef> functionDefs = inputDef.getFunctionInputDefs();
        while (functionDefs.hasNext()) {
            FunctionInputDef functionDef = functionDefs.next();
            FunctionTestDef functionBase = baseDef == null ? null : baseDef.getFunctionTestDef(functionDef.getName());
            ITestCaseGenerator functionGen = genDef.getGenerator(functionDef.getName());
            FunctionTestDef functionTestDef = Tcases.getTests(functionDef, functionGen, functionBase, options);
            Tcases.annotateTests(inputDef, functionTestDef);
            testDef.addFunctionTestDef(functionTestDef);
        }
        testDef.addAnnotations(inputDef);
        return testDef;
    }

    public static FunctionTestDef getTests(FunctionInputDef functionDef, ITestCaseGenerator functionGen, FunctionTestDef functionBase, GeneratorOptions options) {
        Integer defaultTupleSize;
        if (functionGen == null) {
            throw new RuntimeException("No generator for function=" + functionDef.getName());
        }
        Long seed = options == null ? null : options.getRandomSeed();
        Integer n = defaultTupleSize = options == null ? null : options.getDefaultTupleSize();
        if (seed != null) {
            functionGen.setRandomSeed(seed);
        }
        if (defaultTupleSize != null && functionGen instanceof TupleGenerator) {
            ((TupleGenerator)functionGen).setDefaultTupleSize(defaultTupleSize);
        }
        FunctionTestDef functionTestDef = functionGen.getTests(functionDef, functionBase);
        Tcases.annotateTests(functionDef, functionTestDef);
        return functionTestDef;
    }

    public static FunctionTestDef getTests(FunctionInputDef functionDef, ITestCaseGenerator functionGen, FunctionTestDef functionBase) {
        return Tcases.getTests(functionDef, functionGen, functionBase, null);
    }

    public static SystemTestDef getTests(SystemInputDef inputDef, IGeneratorSet genDef, SystemTestDef baseDef) {
        return Tcases.getTests(inputDef, genDef, baseDef, null);
    }

    static void annotateTests(FunctionInputDef functionInputDef, FunctionTestDef functionTestDef) {
        functionTestDef.addAnnotations(functionInputDef);
        Iterator<TestCase> testCases = functionTestDef.getTestCases();
        while (testCases.hasNext()) {
            TestCase testCase = testCases.next();
            testCase.addAnnotations(functionInputDef);
            Iterator<VarBinding> varBindings = testCase.getVarBindings();
            while (varBindings.hasNext()) {
                VarBinding binding = varBindings.next();
                VarDef varDef = functionInputDef.findVarDefPath(binding.getVar());
                if (!binding.isValueNA()) {
                    VarValueDef valueDef = varDef.getValue(binding.getValue());
                    binding.addAnnotations(valueDef);
                }
                binding.addAnnotations(varDef);
                for (IVarDef ancestor = varDef.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                    if (!(ancestor instanceof Annotated)) continue;
                    binding.addAnnotations((Annotated)((Object)ancestor));
                }
            }
        }
    }

    static void annotateTests(SystemInputDef inputDef, FunctionTestDef functionTestDef) {
        functionTestDef.addAnnotations(inputDef);
        Iterator<TestCase> testCases = functionTestDef.getTestCases();
        while (testCases.hasNext()) {
            TestCase testCase = testCases.next();
            testCase.addAnnotations(inputDef);
        }
    }
}

