/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.FunctionTestDef;
import org.cornutum.tcases.util.ToString;

public class SystemTestDef
extends Annotated {
    private String name_;
    private List<FunctionTestDef> functionTestDefs_ = new ArrayList<FunctionTestDef>();

    public SystemTestDef() {
        this(null);
    }

    public SystemTestDef(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        DefUtils.assertIdentifier(name);
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public SystemTestDef addFunctionTestDef(FunctionTestDef functionTestDef) {
        assert (functionTestDef != null);
        assert (functionTestDef.getName() != null);
        if (this.findFunctionTestDef(functionTestDef.getName()) >= 0) {
            throw new IllegalStateException("Function=" + functionTestDef.getName() + " already defined for system=" + this.getName());
        }
        this.functionTestDefs_.add(functionTestDef);
        return this;
    }

    public SystemTestDef removeFunctionTestDef(String name) {
        int i = this.findFunctionTestDef(name);
        if (i >= 0) {
            this.functionTestDefs_.remove(i);
        }
        return this;
    }

    public FunctionTestDef getFunctionTestDef(String name) {
        int i = this.findFunctionTestDef(name);
        return i >= 0 ? this.functionTestDefs_.get(i) : null;
    }

    public Iterator<FunctionTestDef> getFunctionTestDefs() {
        return this.functionTestDefs_.iterator();
    }

    protected int findFunctionTestDef(String name) {
        int i;
        int functionCount = name == null ? 0 : this.functionTestDefs_.size();
        for (i = 0; i < functionCount && !name.equals(this.functionTestDefs_.get(i).getName()); ++i) {
        }
        return i < functionCount ? i : -1;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getName());
    }

    public boolean equals(Object object) {
        SystemTestDef other = object != null && object.getClass().equals(this.getClass()) ? (SystemTestDef)object : null;
        return other != null && Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return ToString.getBuilder(this).append((Object)this.getName()).toString();
    }
}

