/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.SetValuedMap;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.IConditional;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarDefIterator;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.conditions.Conditions;
import org.cornutum.tcases.util.CollectionUtils;

public final class SystemInputs {
    private SystemInputs() {
    }

    public static Map<String, Collection<VarBindingDef>> getPropertySources(FunctionInputDef function) {
        return SystemInputs.getPropertySources(function.getVarDefs());
    }

    public static Map<String, Collection<VarBindingDef>> getPropertySources(Iterator<IVarDef> varDefs) {
        return SystemInputs.getPropertySources(CollectionUtils.toStream(new VarDefIterator(varDefs)));
    }

    public static Map<String, Collection<VarBindingDef>> getPropertySources(Stream<VarDef> varDefs) {
        SetValuedMap sources = MultiMapUtils.newSetValuedHashMap();
        varDefs.flatMap(var -> CollectionUtils.toStream(var.getValues()).map(value -> new VarBindingDef((VarDef)var, (VarValueDef)value))).forEach(binding -> CollectionUtils.toStream(binding.getValueDef().getProperties()).forEach(p -> sources.put(p, binding)));
        return sources.asMap();
    }

    public static Map<String, Collection<IConditional>> getPropertyReferences(FunctionInputDef function) {
        return SystemInputs.getPropertyReferences(function.getVarDefs());
    }

    public static Map<String, Collection<IConditional>> getPropertyReferences(Iterator<IVarDef> varDefs) {
        return SystemInputs.getPropertyReferences(CollectionUtils.toStream(varDefs));
    }

    public static Map<String, Collection<IConditional>> getPropertyReferences(Stream<IVarDef> varDefs) {
        SetValuedMap refs = MultiMapUtils.newSetValuedHashMap();
        SystemInputs.conditionals(varDefs).forEach(conditional -> Conditions.propertiesReferenced(conditional.getCondition()).forEach(p -> refs.put(p, conditional)));
        return refs.asMap();
    }

    public static Map<String, Collection<VarBindingDef>> getPropertiesUnused(FunctionInputDef function) {
        Map<String, Collection<VarBindingDef>> sources = SystemInputs.getPropertySources(function);
        Collection unused = org.apache.commons.collections4.CollectionUtils.subtract(sources.keySet(), SystemInputs.getPropertyReferences(function).keySet());
        return sources.entrySet().stream().filter(entry -> unused.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Collection)entry.getValue()));
    }

    public static Map<String, Collection<IConditional>> getPropertiesUndefined(FunctionInputDef function) {
        Map<String, Collection<IConditional>> refs = SystemInputs.getPropertyReferences(function);
        Collection undefined = org.apache.commons.collections4.CollectionUtils.subtract(refs.keySet(), SystemInputs.getPropertySources(function).keySet());
        return refs.entrySet().stream().filter(entry -> undefined.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Collection)entry.getValue()));
    }

    public static String getReferenceName(IConditional conditional) {
        return conditional instanceof IVarDef ? String.format("variable=%s", ((IVarDef)conditional).getPathName()) : (conditional instanceof VarBindingDef ? String.format("variable=%s, value=%s", ((VarBindingDef)conditional).getVarDef().getPathName(), String.valueOf(((VarBindingDef)conditional).getValueDef().getName())) : null);
    }

    private static Stream<IConditional> conditionals(Stream<IVarDef> varDefs) {
        return varDefs.flatMap(var -> SystemInputs.conditionals(var));
    }

    private static Stream<IConditional> conditionals(IVarDef var) {
        return Stream.concat(Stream.of(var), Stream.concat(Optional.ofNullable(var.getMembers()).map(members -> CollectionUtils.toStream(members).flatMap(member -> SystemInputs.conditionals(member))).orElse(Stream.empty()), Optional.ofNullable(var.getValues()).map(values -> CollectionUtils.toStream(values).map(value -> new VarBindingDef((VarDef)var, (VarValueDef)value))).orElse(Stream.empty())));
    }
}

