/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.util.ToString;

public class SystemInputDef
extends Annotated {
    private String name_;
    private List<FunctionInputDef> functionInputDefs_ = new ArrayList<FunctionInputDef>();

    public SystemInputDef() {
        this(null);
    }

    public SystemInputDef(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        DefUtils.assertIdentifier(name);
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public SystemInputDef addFunctionInputDef(FunctionInputDef functionInputDef) {
        assert (functionInputDef != null);
        assert (functionInputDef.getName() != null);
        if (this.findFunctionInputDef(functionInputDef.getName()) >= 0) {
            throw new IllegalStateException("Function=" + functionInputDef.getName() + " already defined for system=" + this.getName());
        }
        this.functionInputDefs_.add(functionInputDef);
        return this;
    }

    public SystemInputDef removeFunctionInputDef(String name) {
        int i = this.findFunctionInputDef(name);
        if (i >= 0) {
            this.functionInputDefs_.remove(i);
        }
        return this;
    }

    public FunctionInputDef getFunctionInputDef(String name) {
        int i = this.findFunctionInputDef(name);
        return i >= 0 ? this.functionInputDefs_.get(i) : null;
    }

    public Iterator<FunctionInputDef> getFunctionInputDefs() {
        return this.functionInputDefs_.iterator();
    }

    protected int findFunctionInputDef(String name) {
        int i;
        int functionCount = name == null ? 0 : this.functionInputDefs_.size();
        for (i = 0; i < functionCount && !name.equals(this.functionInputDefs_.get(i).getName()); ++i) {
        }
        return i < functionCount ? i : -1;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getName());
    }

    public boolean equals(Object object) {
        SystemInputDef other = object != null && object.getClass().equals(this.getClass()) ? (SystemInputDef)object : null;
        return other != null && Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return ToString.getBuilder(this).append((Object)this.getName()).toString();
    }
}

