/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import org.cornutum.tcases.util.ToString;

public class ReducerOptions {
    private String function_;
    private double resampleFactor_;
    private int samples_;
    private boolean newSeed_;

    public ReducerOptions() {
        this.setSamples(10);
        this.setResampleFactor(0.0);
    }

    public void setFunction(String function) {
        this.function_ = function;
    }

    public String getFunction() {
        return this.function_;
    }

    public void setSamples(int samples) {
        this.samples_ = samples;
    }

    public int getSamples() {
        return this.samples_;
    }

    public void setResampleFactor(double resampleFactor) {
        if (resampleFactor < -1.0) {
            throw new IllegalArgumentException("Resample factor must be >= -1.0");
        }
        this.resampleFactor_ = resampleFactor;
    }

    public double getResampleFactor() {
        return this.resampleFactor_;
    }

    public void setNewSeed(boolean newSeed) {
        this.newSeed_ = newSeed;
    }

    public boolean isNewSeed() {
        return this.newSeed_;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return ToString.getBuilder(this).append("function", (Object)this.getFunction()).append("samples", this.getSamples()).append("resampleFactor", this.getResampleFactor()).append("newSeed", this.isNewSeed()).build();
    }

    public static class Builder {
        private ReducerOptions options_ = new ReducerOptions();

        public Builder function(String function) {
            this.options_.setFunction(function);
            return this;
        }

        public Builder resampleFactor(double resampleFactor) {
            this.options_.setResampleFactor(resampleFactor);
            return this;
        }

        public Builder samples(int samples) {
            this.options_.setSamples(samples);
            return this;
        }

        public Builder newSeed(boolean newSeed) {
            this.options_.setNewSeed(newSeed);
            return this;
        }

        public ReducerOptions build() {
            return this.options_;
        }
    }
}

