/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.FunctionTestDef;
import org.cornutum.tcases.ReducerOptions;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.SystemTestDef;
import org.cornutum.tcases.generator.GeneratorSet;
import org.cornutum.tcases.generator.ITestCaseGenerator;
import org.cornutum.tcases.generator.TupleGenerator;
import org.cornutum.tcases.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reducer {
    private static final Logger logger_ = LoggerFactory.getLogger(Reducer.class);

    public static Optional<GeneratorSet> reduce(SystemInputDef inputDef, GeneratorSet genDef, SystemTestDef baseDef, ReducerOptions options) {
        Stream<FunctionInputDef> functionInputDefs;
        GeneratorSet genDefNew = genDef.cloneOf();
        String function = options.getFunction();
        if (function == null) {
            functionInputDefs = CollectionUtils.toStream(inputDef.getFunctionInputDefs());
        } else {
            if (inputDef.getFunctionInputDef(function) == null) {
                throw new RuntimeException("Function=" + function + " is not defined");
            }
            functionInputDefs = Stream.of(inputDef.getFunctionInputDef(function));
        }
        Map<String, ITestCaseGenerator> generatorsNew = functionInputDefs.map(functionInputDef -> new AbstractMap.SimpleEntry<String, Object>(functionInputDef.getName(), Reducer.reduce(functionInputDef, genDefNew.getGenerator(functionInputDef.getName()), baseDef == null ? null : baseDef.getFunctionTestDef(functionInputDef.getName()), options).orElse(null))).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        if (generatorsNew.isEmpty()) {
            logger_.info("Generator definitions not changed");
            return Optional.empty();
        }
        generatorsNew.forEach((f, g) -> genDefNew.setGenerator((String)f, (ITestCaseGenerator)g));
        return Optional.of(genDefNew);
    }

    public static Optional<GeneratorSet> reduce(SystemInputDef inputDef) {
        return Reducer.reduce(inputDef, GeneratorSet.basicGenerator(), null, new ReducerOptions());
    }

    public static Optional<ITestCaseGenerator> reduce(FunctionInputDef inputDef, ITestCaseGenerator generator, FunctionTestDef baseDef, ReducerOptions options) {
        Optional<ITestCaseGenerator> reduced;
        ITestCaseGenerator generatorNew;
        String function = inputDef.getName();
        ITestCaseGenerator iTestCaseGenerator = generatorNew = generator == null ? new TupleGenerator() : (ITestCaseGenerator)generator.cloneOf();
        if (options.isNewSeed()) {
            generatorNew.setRandomSeed(null);
        }
        logger_.info("[{}] Initializing test cases to be reduced", (Object)function);
        int initialCount = Reducer.getTestCaseCount(inputDef, generatorNew, baseDef);
        int samples = options.getSamples();
        int round = 1;
        int minCount = initialCount;
        long minSeed = 0L;
        long eqSeed = 0L;
        boolean reducing = true;
        Random random = new Random();
        while (samples > 0 && reducing) {
            int i;
            logger_.info("[{}] Round {}: starting next {} samples", new Object[]{function, round, samples});
            int roundCount = 0;
            long roundSeed = 0L;
            for (i = 0; i < samples && (roundCount = Reducer.getTestCaseCount(inputDef, generatorNew, baseDef, roundSeed = (long)(random.nextDouble() * 9.223372036854776E18))) >= minCount; ++i) {
                eqSeed = roundCount == minCount ? roundSeed : eqSeed;
            }
            boolean bl = reducing = i < samples;
            if (reducing) {
                logger_.info("[{}] Round {}: after {} samples, reached {} test cases with seed={}", new Object[]{function, round, i + 1, roundCount, roundSeed});
                minCount = roundCount;
                minSeed = roundSeed;
            } else {
                logger_.info("[{}] Round {}: after {} samples, terminating with {} test cases", new Object[]{function, round, samples, minCount});
            }
            samples = (int)Math.floor((double)samples * (1.0 + options.getResampleFactor()));
            ++round;
        }
        if (minCount < initialCount || options.isNewSeed() && eqSeed != 0L) {
            minSeed = minSeed == 0L ? eqSeed : minSeed;
            logger_.info("[{}] Reduced to {} test cases with seed={} -- updating generator definition", new Object[]{function, minCount, minSeed});
            generatorNew.setRandomSeed(minSeed);
            reduced = Optional.of(generatorNew);
        } else {
            logger_.info("[{}] Could not reduce initial {} test cases", new Object[]{function, initialCount});
            reduced = Optional.empty();
        }
        return reduced;
    }

    public static Optional<ITestCaseGenerator> reduce(FunctionInputDef inputDef) {
        return Reducer.reduce(inputDef, new TupleGenerator(), null, new ReducerOptions());
    }

    private static int getTestCaseCount(FunctionInputDef inputDef, ITestCaseGenerator generator, FunctionTestDef baseDef) {
        return (int)CollectionUtils.toStream(generator.getTests(inputDef, baseDef).getTestCases()).count();
    }

    private static int getTestCaseCount(FunctionInputDef inputDef, ITestCaseGenerator generator, FunctionTestDef baseDef, long seed) {
        generator.setRandomSeed(seed);
        return Reducer.getTestCaseCount(inputDef, generator, baseDef);
    }
}

