/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.util.ToString;

public class PropertySet
implements Iterable<String> {
    private HashBag<String> properties_ = new HashBag();

    public PropertySet() {
        this((Collection<String>)null);
    }

    public PropertySet(String ... properties) {
        this(Arrays.asList(properties));
    }

    public PropertySet(Collection<String> properties) {
        this.addAll(properties);
    }

    public PropertySet(PropertySet properties) {
        this.addAll(properties);
    }

    public PropertySet add(String property) {
        String candidate = StringUtils.trimToNull((String)property);
        if (candidate != null) {
            this.properties_.add((Object)candidate);
        }
        return this;
    }

    public PropertySet addAll(PropertySet propertySet) {
        if (propertySet != null) {
            this.addAll((Collection<String>)propertySet.properties_);
        }
        return this;
    }

    public PropertySet addAll(Collection<String> properties) {
        if (properties != null) {
            this.addAll(properties.iterator());
        }
        return this;
    }

    public PropertySet addAll(Iterator<String> properties) {
        if (properties != null) {
            while (properties.hasNext()) {
                this.add(properties.next());
            }
        }
        return this;
    }

    public PropertySet remove(String property) {
        String candidate = StringUtils.trimToNull((String)property);
        if (candidate != null) {
            this.properties_.remove((Object)candidate, 1);
        }
        return this;
    }

    public PropertySet removeAll(Collection<String> properties) {
        if (properties != null) {
            this.removeAll(properties.iterator());
        }
        return this;
    }

    public PropertySet removeAll(PropertySet properties) {
        if (properties != null) {
            this.removeAll((Collection<String>)properties.properties_);
        }
        return this;
    }

    public PropertySet removeAll(Iterator<String> properties) {
        if (properties != null) {
            while (properties.hasNext()) {
                this.remove(properties.next());
            }
        }
        return this;
    }

    public void clear() {
        this.properties_.clear();
    }

    public boolean contains(String property) {
        return this.properties_.contains((Object)property);
    }

    @Override
    public Iterator<String> iterator() {
        return this.properties_.iterator();
    }

    public Iterator<String> getUniqueProperties() {
        return this.properties_.uniqueSet().iterator();
    }

    public int getCount(String property) {
        return this.properties_.getCount((Object)StringUtils.trimToNull((String)property));
    }

    public boolean isEmpty() {
        return this.properties_.isEmpty();
    }

    public String toString() {
        return ToString.getBuilder(this).append(this.properties_).toString();
    }
}

