/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.TestCase;
import org.cornutum.tcases.util.ToString;

public class FunctionTestDef
extends Annotated {
    private String name_;
    private List<TestCase> testCases_ = new ArrayList<TestCase>();

    public FunctionTestDef() {
        this(null);
    }

    public FunctionTestDef(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        DefUtils.assertIdentifier(name);
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public FunctionTestDef addTestCase(TestCase testCase) {
        assert (testCase != null);
        if (this.findTestCase(testCase.getId()) >= 0) {
            throw new IllegalStateException("Test=" + testCase.getId() + " already defined for function=" + this.getName());
        }
        this.testCases_.add(testCase);
        return this;
    }

    public FunctionTestDef removeTestCase(int id) {
        int i = this.findTestCase(id);
        if (i >= 0) {
            this.testCases_.remove(i);
        }
        return this;
    }

    public TestCase getTestCase(int id) {
        int i = this.findTestCase(id);
        return i >= 0 ? this.testCases_.get(i) : null;
    }

    public Iterator<TestCase> getTestCases() {
        return this.testCases_.iterator();
    }

    protected int findTestCase(int id) {
        int i;
        int testCount = this.testCases_.size();
        for (i = 0; i < testCount && this.testCases_.get(i).getId() != id; ++i) {
        }
        return i < testCount ? i : -1;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getName());
    }

    public boolean equals(Object object) {
        FunctionTestDef other = object != null && object.getClass().equals(this.getClass()) ? (FunctionTestDef)object : null;
        return other != null && Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return ToString.getBuilder(this).append((Object)this.getName()).toString();
    }
}

