/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Arrays;
import java.util.stream.Stream;
import org.cornutum.tcases.AbstractVarDef;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.AnnotatedBuilder;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarDefBuilder;
import org.cornutum.tcases.VarSet;
import org.cornutum.tcases.VarSetBuilder;

public class FunctionInputDefBuilder
extends AnnotatedBuilder<FunctionInputDefBuilder> {
    FunctionInputDef functionInputDef_;

    public static FunctionInputDefBuilder with(String name) {
        return new FunctionInputDefBuilder().name(name);
    }

    public static FunctionInputDefBuilder with(FunctionInputDef functionInputDef) {
        return new FunctionInputDefBuilder(functionInputDef);
    }

    public FunctionInputDefBuilder() {
        this(null);
    }

    public FunctionInputDefBuilder(FunctionInputDef functionInputDef) {
        this.start(functionInputDef);
    }

    public FunctionInputDef build() {
        return this.functionInputDef_;
    }

    public FunctionInputDefBuilder start() {
        return this.start(null);
    }

    public FunctionInputDefBuilder start(FunctionInputDef functionInputDef) {
        this.functionInputDef_ = functionInputDef == null ? new FunctionInputDef("F") : functionInputDef;
        return this;
    }

    public FunctionInputDefBuilder name(String name) {
        this.functionInputDef_.setName(name);
        return this;
    }

    public FunctionInputDefBuilder vars(IVarDef ... vars) {
        for (IVarDef var : vars) {
            this.functionInputDef_.addVarDef(var);
        }
        return this;
    }

    public FunctionInputDefBuilder vars(Iterable<IVarDef> vars) {
        for (IVarDef var : vars) {
            this.functionInputDef_.addVarDef(var);
        }
        return this;
    }

    public FunctionInputDefBuilder vars(Stream<IVarDef> vars) {
        vars.forEach(var -> this.functionInputDef_.addVarDef((IVarDef)var));
        return this;
    }

    public FunctionInputDefBuilder vars(String type, AbstractVarDef ... vars) {
        for (AbstractVarDef var : vars) {
            var.setType(type);
            this.functionInputDef_.addVarDef(var);
        }
        return this;
    }

    public VarSetBuilder varSetAtPath(String pathName) {
        return this.varSetAtPath(DefUtils.toPath(pathName));
    }

    public VarSetBuilder varSetAtPath(String[] path) {
        VarSet varSet = null;
        if (path != null && path.length > 0) {
            varSet = new VarSet(path[0]);
            this.functionInputDef_.addVarDef(varSet);
            for (int i = 1; i < path.length; ++i) {
                VarSet child = new VarSet(path[i]);
                varSet.addMember(child);
                varSet = child;
            }
        }
        return varSet == null ? null : new VarSetBuilder(varSet);
    }

    public VarDefBuilder varDefAtPath(String pathName) {
        return this.varDefAtPath(DefUtils.toPath(pathName));
    }

    public VarDefBuilder varDefAtPath(String[] path) {
        VarDefBuilder varDefBuilder = null;
        if (path != null && path.length > 0) {
            String varDefName = path[path.length - 1];
            VarSetBuilder parentBuilder = this.varSetAtPath(Arrays.copyOfRange(path, 0, path.length - 1));
            if (parentBuilder != null) {
                varDefBuilder = parentBuilder.varDefAtPath(varDefName);
            } else {
                VarDef varDef = new VarDef(varDefName);
                this.functionInputDef_.addVarDef(varDef);
                varDefBuilder = new VarDefBuilder(varDef);
            }
        }
        return varDefBuilder;
    }

    @Override
    protected Annotated getAnnotated() {
        return this.functionInputDef_;
    }
}

