/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.util.ToString;

public class FunctionInputDef
extends Annotated {
    private String name_;
    private List<IVarDef> vars_ = new ArrayList<IVarDef>();

    public FunctionInputDef() {
        this(null);
    }

    public FunctionInputDef(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        DefUtils.assertIdentifier(name);
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public FunctionInputDef addVarDef(IVarDef varDef) {
        assert (varDef != null);
        assert (varDef.getName() != null);
        if (this.findVarDef(varDef.getName()) >= 0) {
            throw new IllegalStateException("Variable=" + varDef.getName() + " already defined for function=" + this.getName());
        }
        this.vars_.add(varDef);
        return this;
    }

    public FunctionInputDef removeVarDef(String name) {
        int i = this.findVarDef(name);
        if (i >= 0) {
            this.vars_.remove(i);
        }
        return this;
    }

    public IVarDef getVarDef(String name) {
        int i = this.findVarDef(name);
        return i >= 0 ? this.vars_.get(i) : null;
    }

    public Iterator<IVarDef> getVarDefs() {
        return this.vars_.iterator();
    }

    public String[] getVarTypes() {
        TreeSet<String> typeSet = new TreeSet<String>();
        Iterator<IVarDef> vars = this.getVarDefs();
        while (vars.hasNext()) {
            typeSet.add(vars.next().getType());
        }
        String[] types = new String[typeSet.size()];
        typeSet.toArray(types);
        return types;
    }

    protected int findVarDef(String name) {
        int i;
        int varCount = name == null ? 0 : this.vars_.size();
        for (i = 0; i < varCount && !name.equals(this.vars_.get(i).getName()); ++i) {
        }
        return i < varCount ? i : -1;
    }

    public IVarDef findVarPath(String pathName) {
        IVarDef var;
        String[] path = DefUtils.toPath(pathName);
        return path == null ? null : ((var = this.getVarDef(StringUtils.trimToNull((String)path[0]))) == null ? null : var.find(Arrays.copyOfRange(path, 1, path.length)));
    }

    public VarDef findVarDefPath(String pathName) {
        IVarDef var = this.findVarPath(pathName);
        return var != null && var.getClass().equals(VarDef.class) ? (VarDef)var : null;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getName());
    }

    public boolean equals(Object object) {
        FunctionInputDef other = object != null && object.getClass().equals(this.getClass()) ? (FunctionInputDef)object : null;
        return other != null && Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return ToString.getBuilder(this).append((Object)this.getName()).toString();
    }
}

