/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DefUtils {
    private static final String identifierChars_ = "\\p{Alpha}\\p{Digit}_\\-";
    private static final Pattern identifierRegex_ = Pattern.compile("[\\p{Alpha}\\p{Digit}_\\-]+", 256);
    private static final Pattern nonIdentifierCharRegex_ = Pattern.compile("[^\\p{Alpha}\\p{Digit}_\\-]", 256);
    private static final Pattern varValueRegex_ = Pattern.compile("([^\\p{Cntrl}]|\\s)*");
    private static final Pattern numberRegex_ = Pattern.compile("(-)?(\\d+)(\\.(\\d+))?");

    private DefUtils() {
    }

    public static boolean isIdentifier(String id) {
        return id != null && identifierRegex_.matcher(id).matches();
    }

    public static String[] toPath(String pathName) {
        return pathName == null ? null : pathName.split("\\.", -1);
    }

    public static void assertIdentifier(String id) throws IllegalArgumentException {
        if (!DefUtils.isIdentifier(id)) {
            throw new IllegalArgumentException((id == null ? "null" : "\"" + String.valueOf(id) + "\"") + " is not a valid identifier");
        }
    }

    public static boolean isVarValue(Object val) {
        return val == null || !val.getClass().equals(String.class) || varValueRegex_.matcher(val.toString()).matches();
    }

    public static void assertVarValue(Object val) throws IllegalArgumentException {
        if (!DefUtils.isVarValue(val)) {
            throw new IllegalArgumentException("\"" + String.valueOf(val) + "\" is not a valid variable value");
        }
    }

    public static void assertPath(String pathName) throws IllegalArgumentException {
        String[] ids = DefUtils.toPath(pathName);
        for (int i = 0; i < ids.length; ++i) {
            DefUtils.assertIdentifier(ids[i]);
        }
    }

    public static void assertPropertyIdentifiers(Collection<String> properties) throws IllegalArgumentException {
        if (properties != null) {
            for (String property : properties) {
                DefUtils.assertIdentifier(property);
            }
        }
    }

    public static String toIdentifier(String name) {
        return nonIdentifierCharRegex_.matcher(DefUtils.toNumberIdentifiers(name).replaceAll("\\s+", "-")).replaceAll("");
    }

    public static String toIdentifier(Number number) {
        return DefUtils.toNumberIdentifiers(String.valueOf(number));
    }

    public static String toNumberIdentifiers(String text) {
        Matcher numberMatcher = numberRegex_.matcher(text);
        StringBuffer replaced = new StringBuffer();
        while (numberMatcher.find()) {
            numberMatcher.appendReplacement(replaced, String.format("%s%s%s%s", Optional.ofNullable(numberMatcher.group(1)).map(sign -> "m").orElse(""), numberMatcher.group(2), Optional.ofNullable(numberMatcher.group(3)).map(dot -> "d").orElse(""), Optional.ofNullable(numberMatcher.group(4)).orElse("")));
        }
        numberMatcher.appendTail(replaced);
        return replaced.toString();
    }
}

