/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.stream.Stream;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.IConditional;
import org.cornutum.tcases.conditions.AllOf;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.util.CollectionUtils;

public abstract class Conditional
extends Annotated
implements IConditional {
    private ICondition condition_;

    public void setCondition(ICondition condition) {
        this.condition_ = condition;
    }

    @Override
    public ICondition getCondition() {
        return this.condition_;
    }

    public ICondition getEffectiveCondition(ICondition contextCondition) {
        ICondition effCondition;
        ICondition condition = this.getCondition();
        if (condition == null && contextCondition == null) {
            effCondition = ICondition.ALWAYS;
        } else if (condition == null && contextCondition != null) {
            effCondition = contextCondition;
        } else if (condition != null && (contextCondition == null || contextCondition.equals(condition))) {
            effCondition = condition;
        } else {
            AllOf conjunction = new AllOf(new ICondition[0]);
            Stream.of(condition, contextCondition).flatMap(c -> c instanceof AllOf ? CollectionUtils.toStream(((AllOf)c).getConditions()) : Stream.of(c)).forEach(c -> conjunction.add((ICondition)c));
            effCondition = conjunction;
        }
        return effCondition;
    }
}

