/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.cornutum.tcases.Annotated;
import org.cornutum.tcases.util.CollectionUtils;

public abstract class AnnotatedBuilder<T extends AnnotatedBuilder<T>> {
    protected abstract Annotated getAnnotated();

    public T has(String name, Object value) {
        this.getAnnotated().setAnnotation(name, Objects.toString(value, null));
        return (T)this;
    }

    public T has(String name, Object ... values) {
        return this.has(name, Arrays.stream(values));
    }

    public T has(String name, Iterable<?> values) {
        return this.has(name, CollectionUtils.toStream(values));
    }

    public T has(String name, Stream<?> values) {
        return this.hasIf(name, Optional.ofNullable(values).map(CollectionUtils::toCsv));
    }

    public T hasIf(String name, Iterable<?> values) {
        return this.hasIf(name, CollectionUtils.toStream(values));
    }

    public T hasIf(String name, Stream<?> values) {
        return this.hasIf(name, Optional.ofNullable(values).map(CollectionUtils::toCsv).filter(csv -> !csv.isEmpty()));
    }

    public T hasIf(String name, Object value) {
        return this.hasIf(name, Optional.ofNullable(value));
    }

    public T hasIf(String name, Optional<?> value) {
        value.ifPresent(v -> this.has(name, v));
        return (T)this;
    }
}

