/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.IAnnotated;
import org.cornutum.tcases.util.CollectionUtils;

public abstract class Annotated
implements IAnnotated {
    public static final String TEST_CASE_PROPERTIES = "properties";
    private Map<String, String> annotations_ = new HashMap<String, String>();

    public void setAnnotation(String name, String value) {
        String annotation = StringUtils.trimToNull((String)name);
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation name must be non-blank");
        }
        if (value == null) {
            this.annotations_.remove(annotation);
        } else {
            this.annotations_.put(annotation, value);
        }
    }

    public void setAnnotationList(String name, Iterable<?> values) {
        this.setAnnotation(name, Optional.ofNullable(values).map(list -> CollectionUtils.toCsv(CollectionUtils.toStream(list))).orElse(null));
    }

    public void addAnnotations(Annotated other) {
        Iterator<String> otherAnnotations = other.getAnnotations();
        while (otherAnnotations.hasNext()) {
            String name = otherAnnotations.next();
            if (this.getAnnotation(name) != null) continue;
            this.setAnnotation(name, other.getAnnotation(name));
        }
    }

    @Override
    public String getAnnotation(String name) {
        return this.annotations_.get(name);
    }

    public List<String> getAnnotationList(String name) {
        return Optional.ofNullable(this.getAnnotation(name)).map(value -> CollectionUtils.fromCsv(value).collect(Collectors.toList())).orElse(null);
    }

    @Override
    public Iterator<String> getAnnotations() {
        return this.annotations_.keySet().iterator();
    }

    public int getAnnotationCount() {
        return this.annotations_.size();
    }
}

