/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.cornutum.tcases.Conditional;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.util.ToString;

public abstract class AbstractVarDef
extends Conditional
implements IVarDef {
    private String name_;
    private String type_;
    private IVarDef parent_;
    private String pathName_;
    private Position position_;
    private int seqNum_;
    private ICondition effCondition_;
    private static AtomicInteger nextSeqNum_ = new AtomicInteger();

    public AbstractVarDef() {
        this(null);
    }

    public AbstractVarDef(String name) {
        this.setName(name);
        this.setType("arg");
        this.setSeqNum(this.getNextSeqNum());
    }

    public void setName(String name) {
        DefUtils.assertIdentifier(name);
        this.name_ = name;
        this.pathName_ = null;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getPathName() {
        if (this.pathName_ == null) {
            String name;
            StringBuilder pathName = new StringBuilder();
            IVarDef parent = this.getParent();
            if (parent != null) {
                pathName.append(parent.getPathName()).append('.');
            }
            if ((name = this.getName()) != null) {
                pathName.append(name);
            }
            this.pathName_ = pathName.toString();
        }
        return this.pathName_;
    }

    public void setType(String type) {
        DefUtils.assertIdentifier(type);
        this.type_ = type;
    }

    @Override
    public String getType() {
        IVarDef parent = this.getParent();
        return parent == null ? this.type_ : parent.getType();
    }

    @Override
    public void setParent(IVarDef parent) {
        this.parent_ = parent;
        this.pathName_ = null;
        this.effCondition_ = null;
        this.position_ = null;
    }

    @Override
    public IVarDef getParent() {
        return this.parent_;
    }

    @Override
    public ICondition getEffectiveCondition() {
        if (this.effCondition_ == null) {
            this.effCondition_ = this.getEffectiveCondition(Optional.ofNullable(this.getParent()).map(IVarDef::getEffectiveCondition).orElse(null));
        }
        return this.effCondition_;
    }

    public boolean isOptional() {
        return !this.getEffectiveCondition().equals(ICondition.ALWAYS);
    }

    @Override
    public void setCondition(ICondition condition) {
        super.setCondition(condition);
        this.effCondition_ = null;
    }

    private void setPosition(Position position) {
        this.position_ = position;
    }

    @Override
    public IVarDef.Position getPosition() {
        if (this.position_ == null) {
            this.setPosition(new Position(this.getParent(), this.seqNum_));
        }
        return this.position_;
    }

    @Override
    public void setSeqNum(int seqNum) {
        this.seqNum_ = seqNum;
    }

    @Override
    public int getSeqNum() {
        return this.seqNum_;
    }

    protected int getNextSeqNum() {
        return nextSeqNum_.getAndIncrement();
    }

    @Override
    public abstract Iterator<IVarDef> getMembers();

    @Override
    public abstract Iterator<VarValueDef> getValues();

    @Override
    public abstract IVarDef find(String ... var1);

    public String toString() {
        return ToString.getBuilder(this).append((Object)this.getPathName()).toString();
    }

    public boolean equals(Object object) {
        AbstractVarDef other = object != null && object.getClass().equals(this.getClass()) ? (AbstractVarDef)object : null;
        return other != null && Objects.equals(other.getPathName(), this.getPathName());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getPathName());
    }

    private static class Position
    implements IVarDef.Position {
        private int[] path_;

        public Position(IVarDef parent, int seqNum) {
            int[] parentPosition = parent == null ? null : this.toPosition((IVarDef.Position)parent.getPosition()).path_;
            this.path_ = ArrayUtils.add((int[])parentPosition, (int)seqNum);
        }

        @Override
        public int compareTo(IVarDef.Position other) {
            Position position = this.toPosition(other);
            int delta = 0;
            int parentLength = Math.min(this.path_.length, position.path_.length);
            for (int i = 0; i < parentLength && (delta = this.path_[i] - position.path_[i]) == 0; ++i) {
            }
            if (delta == 0) {
                delta = this.path_.length - position.path_.length;
            }
            return delta;
        }

        private Position toPosition(IVarDef.Position other) {
            Position position;
            Position position2 = position = other != null && other.getClass().equals(this.getClass()) ? (Position)other : null;
            if (position == null) {
                throw new IllegalArgumentException(String.valueOf(this) + " is not comparable with " + other);
            }
            return position;
        }
    }
}

