/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.CommandUtils;
import org.cornutum.tcases.HelpException;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.SystemTestDef;
import org.cornutum.tcases.Tcases;
import org.cornutum.tcases.openapi.ModelConditionNotifier;
import org.cornutum.tcases.openapi.ModelOptions;
import org.cornutum.tcases.openapi.Notifier;
import org.cornutum.tcases.openapi.ServerSelector;
import org.cornutum.tcases.openapi.io.TcasesOpenApiIO;
import org.cornutum.tcases.openapi.moco.MocoServerTestWriter;
import org.cornutum.tcases.openapi.moco.MocoTestConfigReader;
import org.cornutum.tcases.openapi.resolver.RequestCases;
import org.cornutum.tcases.openapi.resolver.RequestTestDef;
import org.cornutum.tcases.openapi.resolver.ResolverConditionNotifier;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.restassured.RestAssuredTestCaseWriter;
import org.cornutum.tcases.openapi.testwriter.JUnitTestWriter;
import org.cornutum.tcases.openapi.testwriter.JavaTestTarget;
import org.cornutum.tcases.openapi.testwriter.TestCaseWriter;
import org.cornutum.tcases.openapi.testwriter.TestCaseWriterFactory;
import org.cornutum.tcases.openapi.testwriter.TestNgTestWriter;
import org.cornutum.tcases.openapi.testwriter.TestSource;
import org.cornutum.tcases.openapi.testwriter.TestTarget;
import org.cornutum.tcases.openapi.testwriter.TestTargetFactory;
import org.cornutum.tcases.openapi.testwriter.TestWriter;
import org.cornutum.tcases.openapi.testwriter.TestWriterException;
import org.cornutum.tcases.openapi.testwriter.TestWriterFactory;
import org.cornutum.tcases.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTestCommand {
    private static final Logger logger_ = LoggerFactory.getLogger(ApiTestCommand.class);

    private ApiTestCommand() {
    }

    public static void main(String[] args) {
        int exitCode = 0;
        try {
            ApiTestCommand.run(new Options(args));
        }
        catch (HelpException h) {
            exitCode = 1;
        }
        catch (Throwable e) {
            exitCode = 1;
            e.printStackTrace(System.err);
        }
        finally {
            System.exit(exitCode);
        }
    }

    public static void run(Options options) throws Exception {
        if (options.showVersion()) {
            System.out.println(CommandUtils.getVersion());
            return;
        }
        logger_.info("{}", (Object)CommandUtils.getVersion());
        File apiDefFile = options.getApiDef();
        if (apiDefFile != null && !apiDefFile.isAbsolute()) {
            apiDefFile = new File(options.getWorkingDir(), apiDefFile.getPath());
        }
        logger_.info("Reading API definition from {}", (Object)Objects.toString(apiDefFile, "standard input"));
        SystemInputDef inputDef = TcasesOpenApiIO.getRequestInputModel((File)apiDefFile, (String)options.getContentType(), (ModelOptions)options.getModelOptions());
        if (inputDef == null) {
            logger_.warn("No requests defined");
        } else {
            if (options.getRandomSeed() == null) {
                options.setRandomSeed(options.getDefaultRandomSeed());
            }
            if (options.getModelOptions().getSource().equals((Object)ModelOptions.Source.EXAMPLES)) {
                logger_.info("Generating request test cases using API examples");
            } else {
                logger_.info("Generating request test cases using random seed={}", (Object)options.getRandomSeed());
            }
            RequestTestDef testDef = RequestCases.getRequestCases((SystemTestDef)Tcases.getTests((SystemInputDef)inputDef, null, null), (ResolverContext)options.getResolverContext());
            TestSource testSource = options.getTestSource(RequestCases.realizeRequestCases((RequestTestDef)testDef));
            TestCaseWriter testCaseWriter = options.getTestCaseWriter();
            TestWriter<?, ?> testWriter = options.getTestWriter(testCaseWriter);
            TestTarget testTarget = options.getTestTarget();
            if (ApiTestCommand.getTestFile(testWriter, testSource, testTarget) == null && apiDefFile != null) {
                testTarget.setDir(apiDefFile.getParentFile());
            }
            logger_.info("Writing API tests using {} and {}", testWriter, (Object)testCaseWriter);
            if (options.isByPath()) {
                String testBaseName = ApiTestCommand.getTestName(testWriter, testSource, testTarget);
                File testBaseFile = ApiTestCommand.getTestFile(testWriter, testSource, testTarget);
                testTarget.setFile((File)null);
                testTarget.setDir((File)Optional.ofNullable(testTarget.getDir()).orElse(Optional.ofNullable(testBaseFile).map(File::getParentFile).orElse(null)));
                Set<String> testPaths = Optional.ofNullable(options.getPaths()).orElse(testSource.getTestDef().getPaths());
                for (String testPath : testPaths) {
                    testSource.setPaths(Collections.singleton(testPath));
                    testTarget.setName(String.format("%s_%s", testBaseName, testPath));
                    logger_.info("Writing API tests for {} to {}", (Object)testPath, (Object)Objects.toString(ApiTestCommand.getTestFile(testWriter, testSource, testTarget), "standard output"));
                    ApiTestCommand.writeTest(testWriter, testSource, testTarget);
                }
            } else {
                logger_.info("Writing all API tests to {}", (Object)Objects.toString(ApiTestCommand.getTestFile(testWriter, testSource, testTarget), "standard output"));
                ApiTestCommand.writeTest(testWriter, testSource, testTarget);
            }
        }
    }

    private static File getTestFile(TestWriter<?, ?> testWriter, TestSource testSource, TestTarget testTarget) {
        Throwable failure = null;
        File testFile = null;
        try {
            testFile = (File)testWriter.getClass().getMethod("getTestFile", TestSource.class, TestTarget.class).invoke(testWriter, testSource, testTarget);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getCause();
        }
        catch (Exception e) {
            failure = e;
        }
        if (failure != null) {
            throw new TestWriterException(String.format("Can't get test file for %s", testWriter), failure);
        }
        return testFile;
    }

    private static String getTestName(TestWriter<?, ?> testWriter, TestSource testSource, TestTarget testTarget) {
        Throwable failure = null;
        String testName = null;
        try {
            testName = (String)testWriter.getClass().getMethod("getTestName", TestSource.class, TestTarget.class).invoke(testWriter, testSource, testTarget);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getCause();
        }
        catch (Exception e) {
            failure = e;
        }
        if (failure != null) {
            throw new TestWriterException(String.format("Can't get test name for %s", testWriter), failure);
        }
        return testName;
    }

    private static void writeTest(TestWriter<?, ?> testWriter, TestSource testSource, TestTarget testTarget) {
        Throwable failure = null;
        try {
            testWriter.getClass().getMethod("writeTest", TestSource.class, TestTarget.class).invoke(testWriter, testSource, testTarget);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getCause();
        }
        catch (Exception e) {
            failure = e;
        }
        if (failure != null) {
            throw new TestWriterException(String.format("%s: Can't write test for %s", testWriter, testSource), failure);
        }
    }

    public static class Options
    implements TestTargetFactory,
    TestWriterFactory,
    TestCaseWriterFactory {
        private File apiDef_;
        private TestType testType_;
        private ExecType execType_;
        private String testName_;
        private String testPackage_;
        private String baseClass_;
        private File outDir_;
        private File outFile_;
        private Long timeout_;
        private File mocoTestConfig_;
        private boolean byPath_;
        private Set<String> paths_;
        private Set<String> operations_;
        private String contentType_;
        private ModelOptions modelOptions_;
        private ResolverContext resolverContext_;
        private File workingDir_;
        private boolean showVersion_;
        private Long randomSeed_;
        private static final Pattern serverExprPattern_ = Pattern.compile("(index|contains|uri)=(.+)");

        public Options() {
            this.setWorkingDir(null);
            this.setTestType(TestType.JUNIT);
            this.setExecType(ExecType.RESTASSURED);
            this.setModelOptions(new ModelOptions());
            this.setResolverContext(new ResolverContext(new Random()));
        }

        public Options(String[] args) {
            this();
            int i = 0;
            while (i < args.length && args[i].charAt(0) == '-') {
                i = this.handleOption(args, i);
            }
            this.handleArgs(args, i);
        }

        protected int handleOption(String[] args, int i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                this.throwHelpException();
            } else if (arg.equals("-X")) {
                this.setSource(ModelOptions.Source.EXAMPLES);
            } else if (arg.equals("-t")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setTestType(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid test type", e);
                }
            } else if (arg.equals("-e")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setExecType(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid exec type", e);
                }
            } else if (arg.equals("-n")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setTestName(args[i]);
            } else if (arg.equals("-p")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setTestPackage(args[i]);
            } else if (arg.equals("-b")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setBaseClass(args[i]);
            } else if (arg.equals("-f")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOutFile(new File(args[i]));
            } else if (arg.equals("-o")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOutDir(new File(args[i]));
            } else if (arg.equals("-u")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setTimeout(Long.valueOf(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid timeout", e);
                }
            } else if (arg.equals("-M")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setMocoTestConfig(new File(args[i]));
            } else if (arg.equals("-P")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setPaths(Arrays.asList(args[i].split(" *, *")));
            } else if (arg.equals("-S")) {
                this.setByPath(true);
            } else if (arg.equals("-O")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOperations(Arrays.asList(args[i].split(" *, *")));
            } else if (arg.equals("-B")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setServerUri(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid base URI", e);
                }
            } else if (arg.equals("-c")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setConditionNotifiers(args[i]);
            } else if (arg.equals("-R")) {
                this.setReadOnlyEnforced(true);
            } else if (arg.equals("-r")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setRandomSeed(Long.valueOf(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid random seed", e);
                }
            } else if (arg.equals("-m")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setMaxTries(Integer.parseInt(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid max tries", e);
                }
            } else if (arg.equals("-T")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setContentType(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid content type", e);
                }
            } else if (arg.equals("-v")) {
                this.setShowVersion(true);
            } else {
                CommandUtils.throwUsageException(String.format("Unknown option: %s", arg));
            }
            return i + 1;
        }

        protected void handleArgs(String[] args, int i) {
            int nargs = args.length - i;
            if (nargs > 1) {
                CommandUtils.throwUsageException(String.format("Unexpected argument: %s", args[i + 1]));
            }
            if (nargs > 0) {
                this.setApiDef(new File(args[i]));
            }
        }

        protected void throwHelpException() {
            this.printUsage();
            throw new HelpException();
        }

        protected void printUsage() {
            for (String line : new String[]{"Usage: tcases-api-test [option...] [apiDef]", "", "Generates executable test code for API servers, based on an OpenAPI v3 compliant API definition.", "", "An OpenAPI v3 API definition is read from the given apiDef file. If omitted, the API definition is read from", "standard input. If no outFile is specified, output is written to a default file derived from the", "apiDef or, if no apiDef is given, to standard output.", "", "Each option is one of the following:", "", "  -X              If specified, test cases are generated based on the examples specified in the", "                  apiDef. Otherwise, by default, test cases are created by generating random", "                  request input values.", "", "  -t testType     Defines the test framework used to run API tests. Valid values are 'junit', 'testng',", "                  or 'moco'. If omitted, the default is 'junit'.", "", "                  Use 'moco' to generate a JUnit test that sends requests to a Moco stub server.", "                  To define the Moco server test configuration, use the '-M' option.", "", "  -e execType     Defines the request execution interface used to run API tests. Valid values are", "                  'restassured'. If omitted, the default is 'restassured'.", "", "  -n testName     Defines the name of the test class that is generated. This can be either a fully-", "                  qualified class name or a simple class name. If omitted, the default is based on", "                  the title of the apiDef.", "", "  -p testPackage  Defines the package for the test class that is generated. This can be omitted if", "                  the testName is a fully-qualified class name or if the package can be determined", "                  from the outDir.", "", "  -b baseClass    If defined, specifies a base class for the generated test class. This can be a", "                  fully-qualified class name or a simple class name, if the baseClass belongs to", "                  the same package as the generated test class.", "", "  -f outFile      If defined, output is written to the specified outFile, relative to the given outDir.", "                  If omitted, the default outFile is derived from the testName.", "", "  -o outDir       If -o is defined, output is written to the specified directory. If omitted, the", "                  default outDir is the directory containing the apiDef or, if reading from standard", "                  input, output is written to standard output.", "", "  -u timeout      Defines the maximum time (in milliseconds) to complete an individual test method.", "                  A test failure occurs if a method continues past this time limit. If omitted, no time", "                  limit is enforced.", "", "  -M mocoTestConfig When the testType is 'moco', specifies the Moco server test configuration file.", "", "  -P paths        If defined, tests are generated only for the specified API resource paths. The paths", "                  option must be a comma-separated list of resource paths defined in the apiDef. If", "                  omitted, tests are generated for all resource paths.", "", "  -S              If specified, a separate test file is generated for each of the API resource paths", "                  specified by the -P option, each containing tests for a single path. Otherwise, a", "                  single test file is generated containing tests for all paths.", "", "  -O operations   If defined, tests are generated only for the specified HTTP methods. The operations", "                  option must be a comma-separated list of path operations defined in the apiDef. If", "                  omitted, tests are generated for all operations.", "", "  -B server       If defined, specifies the base URI for the API server used by the generated tests.", "                  The server expression has one of the following forms. If omitted, the default is index=0.", "", "                  index=<integer>", "                       From the servers array defined in the apiDef, use the URI of the given element.", "", "                  contains=<text>", "                       From the servers array defined in the apiDef, use the URI of the first element", "                       with a description containing the given text.", "", "                   uri=<uri>", "                       Use the specified <uri>.", "", "  -T contentType  Defines the content type of the OpenApi definition. The contentType must be one", "                  of 'json', 'yaml', or 'yml'. If omitted, the default content type is derived from the", "                  apiDef name. If the apiDef is read from standard input or does not have a recognized", "                  extension, the default content type is 'json'.", "", "  -c M[,R]        Defines how input modelling and request case resolution conditions are reported.", "                  Both M (for modelling conditions) and R (for resolution conditions) must be one of", "                  'log', 'fail', or 'ignore'. If 'log' is specified, conditions are reported using log", "                  messages. If 'fail' is specified, any condition will cause an exception. If 'ignore'", "                  is specified, all conditions are silently ignored. If R is omitted, the default is", "                  'log'. If -c is omitted, the default is 'log,log'.", "", "  -R              If specified, tests will be generated assuming that the API will strictly enforce", "                  exclusion of 'readOnly' properties from request parameters. If omitted, no strict", "                  enforcement is assumed.", "", "  -r seed         If defined, use the given random number seed to generate request test case input", "                  values. If omitted, the default random number seed is derived from the apiDef name.", "", "  -m maxTries     Defines the maximum attempts made to resolve a request test case input value before", "                  reporting failure. If omitted, the default value is 10000.", "", "  -l logFile      If -l is defined, log output is written to the given file. If omitted,", "                  log output is written to a file named tcases-api-test.log in the current working", "                  directory. If logFile is 'stdout', log output is written to standard output.", "", "  -L logLevel     Defines the level for log output. If omitted, the default level is INFO.", "                  The configuration and levels used for logging are defined by the Logback system.", "", "  -v              Prints the current command version identifier to standard output."}) {
                System.err.println(line);
            }
        }

        public void setTestType(TestType testType) {
            this.testType_ = testType;
        }

        public void setTestType(String testType) {
            this.setTestType(TestType.valueOf(String.valueOf(testType).toUpperCase()));
        }

        public TestType getTestType() {
            return this.testType_;
        }

        public void setExecType(ExecType execType) {
            this.execType_ = execType;
        }

        public void setExecType(String execType) {
            this.setExecType(ExecType.valueOf(String.valueOf(execType).toUpperCase()));
        }

        public ExecType getExecType() {
            return this.execType_;
        }

        public void setSource(ModelOptions.Source source) {
            this.getModelOptions().setSource(source);
        }

        public void setSource(String source) {
            this.setSource(ModelOptions.Source.valueOf((String)String.valueOf(source).toUpperCase()));
        }

        public ModelOptions.Source getSource() {
            return this.getModelOptions().getSource();
        }

        public void setTestName(String testName) {
            List fqn = Optional.ofNullable(StringUtils.trimToNull((String)testName)).map(name -> Arrays.asList(name.split("\\."))).orElse(null);
            Optional.ofNullable(fqn).filter(path -> path.size() > 1).ifPresent(path -> this.setTestPackage(path.subList(0, path.size() - 1).stream().collect(Collectors.joining("."))));
            this.testName_ = Optional.ofNullable(fqn).map(path -> (String)path.get(path.size() - 1)).orElse(null);
        }

        public String getTestName() {
            return this.testName_;
        }

        public void setTestPackage(String testPackage) {
            this.testPackage_ = testPackage;
        }

        public String getTestPackage() {
            return this.testPackage_;
        }

        public void setBaseClass(String baseClass) {
            this.baseClass_ = baseClass;
        }

        public String getBaseClass() {
            return this.baseClass_;
        }

        public void setOutDir(File outDir) {
            this.outDir_ = outDir;
        }

        public File getOutDir() {
            return this.outDir_;
        }

        public void setOutFile(File outFile) {
            this.outFile_ = outFile;
        }

        public File getOutFile() {
            return this.outFile_;
        }

        public void setTimeout(Long millis) {
            this.timeout_ = millis;
        }

        public Long getTimeout() {
            return this.timeout_;
        }

        public void setMocoTestConfig(File mocoTestConfig) {
            this.mocoTestConfig_ = mocoTestConfig;
        }

        public File getMocoTestConfig() {
            return this.mocoTestConfig_;
        }

        public void setPaths(Iterable<String> paths) {
            this.paths_ = Optional.ofNullable(CollectionUtils.toStream(paths)).map(s -> s.collect(Collectors.toSet())).orElse(null);
        }

        public Set<String> getPaths() {
            return this.paths_;
        }

        public void setByPath(boolean byPath) {
            this.byPath_ = byPath;
        }

        public boolean isByPath() {
            return this.byPath_;
        }

        public void setOperations(Iterable<String> operations) {
            this.operations_ = Optional.ofNullable(CollectionUtils.toStream(operations)).map(s -> s.collect(Collectors.toSet())).orElse(null);
        }

        public Set<String> getOperations() {
            return this.operations_;
        }

        public void setServerUri(String serverExpr) throws Exception {
            if (StringUtils.isNotBlank((CharSequence)serverExpr)) {
                Matcher serverMatcher = serverExprPattern_.matcher(serverExpr);
                if (!serverMatcher.matches()) {
                    throw new IllegalArgumentException(String.format("'%s' is not a valid server expression", serverExpr));
                }
                String key = serverMatcher.group(1);
                String value = serverMatcher.group(2);
                if ("index".equals(key)) {
                    this.getModelOptions().setServerSelector(ServerSelector.atIndex((int)Integer.valueOf(value)));
                } else if ("contains".equals(key)) {
                    this.getModelOptions().setServerSelector(ServerSelector.containing((String)value));
                } else {
                    this.getModelOptions().setServerUri(new URI(value));
                }
            }
        }

        public void setContentType(String option) {
            String contentType = Optional.ofNullable(option).map(String::toLowerCase).filter(type -> "json".equals(type) || "yml".equals(type) || "yaml".equals(type)).orElse(null);
            if (option != null && contentType == null) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid content type", option));
            }
            this.contentType_ = contentType;
        }

        public String getContentType() {
            return this.contentType_;
        }

        public void setModelOptions(ModelOptions modelOptions) {
            this.modelOptions_ = modelOptions;
        }

        public ModelOptions getModelOptions() {
            return this.modelOptions_;
        }

        public void setResolverContext(ResolverContext resolverContext) {
            this.resolverContext_ = resolverContext;
        }

        public ResolverContext getResolverContext() {
            return this.resolverContext_;
        }

        public void setRandomSeed(Long seed) {
            this.randomSeed_ = seed;
            if (seed != null) {
                this.getResolverContext().setRandom(new Random(seed));
            }
        }

        public Long getRandomSeed() {
            return this.randomSeed_;
        }

        public Long getDefaultRandomSeed() {
            return Optional.ofNullable(this.getApiDef()).map(def -> def.getName().hashCode()).orElse(new Random().nextLong());
        }

        public void setMaxTries(int maxTries) {
            this.getResolverContext().setMaxTries(maxTries);
        }

        public int getMaxTries() {
            return this.getResolverContext().getMaxTries();
        }

        public void setConditionNotifiers(String notifierList) {
            String[] notifiers = notifierList.split(",", -1);
            String modelNotifier = notifiers.length > 0 ? StringUtils.trimToNull((String)notifiers[0]) : null;
            this.setOnModellingCondition(modelNotifier);
            String resolveNotifier = notifiers.length > 1 ? StringUtils.trimToNull((String)notifiers[1]) : null;
            this.setOnResolverCondition(resolveNotifier);
        }

        public void setOnModellingCondition(String notifier) {
            this.getModelOptions().setConditionNotifier(Optional.ofNullable(notifier == null || "log".equals(notifier) ? ModelConditionNotifier.log() : ("fail".equals(notifier) ? ModelConditionNotifier.fail() : ("ignore".equals(notifier) ? ModelConditionNotifier.ignore() : null))).orElseThrow(() -> CommandUtils.getUsageException("Unknown condition notifier: " + notifier, null)));
        }

        public void setOnResolverCondition(String notifier) {
            this.getResolverContext().setNotifier((Notifier)Optional.ofNullable(notifier == null || "log".equals(notifier) ? ResolverConditionNotifier.log() : ("fail".equals(notifier) ? ResolverConditionNotifier.fail() : ("ignore".equals(notifier) ? ResolverConditionNotifier.ignore() : null))).orElseThrow(() -> CommandUtils.getUsageException("Unknown condition notifier: " + notifier, null)));
        }

        public void setReadOnlyEnforced(boolean enforced) {
            this.getModelOptions().setReadOnlyEnforced(enforced);
        }

        public void setApiDef(File apiDef) {
            this.apiDef_ = apiDef;
        }

        public File getApiDef() {
            return this.apiDef_;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir_ = workingDir == null ? new File(".") : workingDir;
        }

        public File getWorkingDir() {
            return this.workingDir_;
        }

        public void setShowVersion(boolean showVersion) {
            this.showVersion_ = showVersion;
        }

        public boolean showVersion() {
            return this.showVersion_;
        }

        public TestSource getTestSource(RequestTestDef testDef) {
            TestSource testSource = new TestSource(testDef);
            testSource.setPaths(this.getPaths());
            testSource.setOperations(this.getOperations());
            return testSource;
        }

        public TestTarget getTestTarget() {
            return this.createTestTarget();
        }

        public TestWriter<?, ?> getTestWriter(TestCaseWriter testCaseWriter) {
            return this.createTestWriter(testCaseWriter);
        }

        public TestCaseWriter getTestCaseWriter() {
            return this.createTestCaseWriter();
        }

        public TestTarget createTestTarget() {
            return ((JavaTestTarget.Builder)((JavaTestTarget.Builder)((JavaTestTarget.Builder)((JavaTestTarget.Builder)JavaTestTarget.builder().named(this.getTestName())).inPackage(this.getTestPackage()).extending(this.getBaseClass()).toFile(this.getOutFile())).inDir(this.getOutDir())).timeout(this.getTimeout())).build();
        }

        public TestWriter<?, ?> createTestWriter(TestCaseWriter testCaseWriter) {
            MocoServerTestWriter testWriter;
            switch (this.getTestType()) {
                case JUNIT: {
                    testWriter = new JUnitTestWriter(testCaseWriter);
                    break;
                }
                case TESTNG: {
                    testWriter = new TestNgTestWriter(testCaseWriter);
                    break;
                }
                case MOCO: {
                    testWriter = this.createMocoServerTestWriter(testCaseWriter);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s is not a valid test type", new Object[]{this.getTestType()}));
                }
            }
            return testWriter;
        }

        private MocoServerTestWriter createMocoServerTestWriter(TestCaseWriter testCaseWriter) {
            MocoServerTestWriter testWriter;
            try {
                File configFile = Optional.ofNullable(this.getMocoTestConfig()).orElseThrow(() -> new IllegalArgumentException("No Moco server test configuration defined"));
                InputStream configStream = Optional.ofNullable(configFile.exists() ? new FileInputStream(configFile) : this.getClass().getResourceAsStream(configFile.getPath())).orElseThrow(() -> new IllegalStateException(String.format("Moco server test configuration=%s not found", configFile)));
                try (MocoTestConfigReader reader = new MocoTestConfigReader(configStream);){
                    testWriter = reader.getMocoTestConfig().createTestWriter(testCaseWriter);
                }
            }
            catch (Exception e) {
                throw new TestWriterException("Can't create Moco test writer", (Throwable)e);
            }
            return testWriter;
        }

        public TestCaseWriter createTestCaseWriter() {
            return new RestAssuredTestCaseWriter();
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Optional.of(this.getSource()).filter(s -> ModelOptions.Source.EXAMPLES.equals(s)).ifPresent(g -> builder.append(" -X"));
            builder.append(" -t ").append((Object)this.getTestType());
            builder.append(" -e ").append((Object)this.getExecType());
            Optional.ofNullable(this.getTestName()).ifPresent(name -> builder.append(" -n ").append((String)name));
            Optional.ofNullable(this.getTestPackage()).ifPresent(pkg -> builder.append(" -p ").append((String)pkg));
            Optional.ofNullable(this.getBaseClass()).ifPresent(base -> builder.append(" -b ").append((String)base));
            Optional.ofNullable(this.getOutFile()).ifPresent(file -> builder.append(" -f ").append(file.getPath()));
            Optional.ofNullable(this.getOutDir()).ifPresent(dir -> builder.append(" -o ").append(dir.getPath()));
            Optional.ofNullable(this.getTimeout()).ifPresent(timeout -> builder.append(" -u ").append(timeout));
            Optional.ofNullable(this.getMocoTestConfig()).ifPresent(moco -> builder.append(" -M ").append(moco.getPath()));
            if (this.isByPath()) {
                builder.append(" -S");
            }
            Optional.ofNullable(this.getPaths()).ifPresent(paths -> builder.append(" -P ").append(paths.stream().collect(Collectors.joining(","))));
            Optional.ofNullable(this.getOperations()).ifPresent(operations -> builder.append(" -O ").append(operations.stream().collect(Collectors.joining(","))));
            builder.append(" -c ").append(String.format("%s,%s", this.getModelOptions().getConditionNotifier(), this.getResolverContext().getNotifier()));
            Optional.of(this.getModelOptions()).filter(ModelOptions::isReadOnlyEnforced).ifPresent(o -> builder.append(" -R"));
            builder.append(" -m ").append(this.getMaxTries());
            Optional.ofNullable(this.getRandomSeed()).ifPresent(seed -> builder.append(" -r ").append(seed));
            Optional.ofNullable(this.getContentType()).ifPresent(content -> builder.append(" -T ").append((String)content));
            if (this.showVersion()) {
                builder.append(" -v");
            }
            return builder.toString();
        }

        public static class Builder {
            private Options options_ = new Options();

            public Builder apiDef(File apiDef) {
                this.options_.setApiDef(apiDef);
                return this;
            }

            public Builder testType(TestType testType) {
                this.options_.setTestType(testType);
                return this;
            }

            public Builder execType(ExecType execType) {
                this.options_.setExecType(execType);
                return this;
            }

            public Builder source(ModelOptions.Source source) {
                this.options_.setSource(source);
                return this;
            }

            public Builder testName(String testName) {
                this.options_.setTestName(testName);
                return this;
            }

            public Builder testPackage(String testPackage) {
                this.options_.setTestPackage(testPackage);
                return this;
            }

            public Builder baseClass(String baseClass) {
                this.options_.setBaseClass(baseClass);
                return this;
            }

            public Builder outFile(File outFile) {
                this.options_.setOutFile(outFile);
                return this;
            }

            public Builder outDir(File outDir) {
                this.options_.setOutDir(outDir);
                return this;
            }

            public Builder timeout(Long timeout) {
                this.options_.setTimeout(timeout);
                return this;
            }

            public Builder mocoTestConfig(File mocoTestConfig) {
                this.options_.setMocoTestConfig(mocoTestConfig);
                return this;
            }

            public Builder paths(String ... paths) {
                this.options_.setPaths(Arrays.asList(paths));
                return this;
            }

            public Builder byPath() {
                return this.byPath(true);
            }

            public Builder byPath(boolean byPath) {
                this.options_.setByPath(byPath);
                return this;
            }

            public Builder operations(String ... operations) {
                this.options_.setOperations(Arrays.asList(operations));
                return this;
            }

            public Builder serverUri(String serverExpr) throws Exception {
                this.options_.setServerUri(serverExpr);
                return this;
            }

            public Builder contentType(String type) {
                this.options_.setContentType(type);
                return this;
            }

            public Builder onModellingCondition(String notifier) {
                this.options_.setOnModellingCondition(notifier);
                return this;
            }

            public Builder onResolverCondition(String notifier) {
                this.options_.setOnResolverCondition(notifier);
                return this;
            }

            public Builder enforceReadOnly() {
                this.options_.setReadOnlyEnforced(true);
                return this;
            }

            public Builder random(Long seed) {
                this.options_.setRandomSeed(seed);
                return this;
            }

            public Builder maxTries(int maxTries) {
                this.options_.setMaxTries(maxTries);
                return this;
            }

            public Options build() {
                return this.options_;
            }
        }

        public static enum ExecType {
            RESTASSURED;

        }

        public static enum TestType {
            JUNIT,
            TESTNG,
            MOCO;

        }
    }
}

