/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.anon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.cornutum.tcases.CommandUtils;
import org.cornutum.tcases.HelpException;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.TcasesIO;
import org.cornutum.tcases.TcasesJson;
import org.cornutum.tcases.anon.Anonymizer;
import org.cornutum.tcases.generator.IGeneratorSet;
import org.cornutum.tcases.generator.io.GeneratorSetResource;
import org.cornutum.tcases.io.Resource;
import org.cornutum.tcases.io.SystemInputResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonCommand {
    private static final Logger logger_ = LoggerFactory.getLogger(AnonCommand.class);

    private AnonCommand() {
    }

    public static void main(String[] args) {
        int exitCode = 0;
        try {
            AnonCommand.run(new Options(args));
        }
        catch (HelpException h) {
            exitCode = 1;
        }
        catch (Throwable e) {
            exitCode = 1;
            e.printStackTrace(System.err);
        }
        finally {
            System.exit(exitCode);
        }
    }

    public static void run(Options options) throws Exception {
        File genDefDefault;
        File outputDir;
        File inputDefFile;
        if (options.showVersion()) {
            System.out.println(CommandUtils.getVersion());
            return;
        }
        logger_.info("{}", (Object)CommandUtils.getVersion());
        File inputDefOption = options.getInputDef();
        if (inputDefOption != null && !inputDefOption.isAbsolute()) {
            inputDefOption = new File(options.getWorkingDir(), inputDefOption.getPath());
        }
        if (!((inputDefFile = inputDefOption) == null || inputDefFile.exists() || (inputDefFile = new File(inputDefOption.getPath() + "-Input.xml")).exists() || (inputDefFile = new File(inputDefOption.getPath() + ".xml")).exists() || (inputDefFile = new File(inputDefOption.getPath() + "-Input.json")).exists() || (inputDefFile = new File(inputDefOption.getPath() + ".json")).exists())) {
            throw new RuntimeException("Can't locate input file for path=" + options.getInputDef());
        }
        File inputDir = inputDefFile == null ? options.getWorkingDir() : inputDefFile.getParentFile();
        Resource.Type defaultContentType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{options.getContentType(), Resource.Type.of((File)inputDefFile), Resource.Type.XML});
        File outputFile = options.getOutFile();
        if (outputFile != null && (outputDir = outputFile.getParentFile()) != null && !outputDir.exists() && !outputDir.mkdirs()) {
            throw new RuntimeException("Can't create output directory=" + outputDir);
        }
        Resource.Type outputFileType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{Resource.Type.of((File)outputFile), defaultContentType});
        File genDefFile = options.getGenDef();
        if (genDefFile != null) {
            if (!genDefFile.isAbsolute()) {
                genDefFile = new File(inputDir, genDefFile.getPath());
            }
        } else if (inputDefFile != null && (genDefDefault = Resource.withDefaultType((File)new File(inputDir, CommandUtils.getProjectName(inputDefFile) + "-Generators"), (Resource.Type)defaultContentType)).exists()) {
            genDefFile = genDefDefault;
        }
        Resource.Type genDefType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{Resource.Type.of((File)genDefFile), defaultContentType});
        File genOutFile = Optional.ofNullable(genDefFile).flatMap(f -> Optional.ofNullable(outputFile)).map(f -> Resource.withDefaultType((File)new File(f.getParentFile(), CommandUtils.getProjectName(f) + "-Generators"), (Resource.Type)outputFileType)).orElse(null);
        logger_.info("Reading system input definition={}", (Object)inputDefFile);
        SystemInputDef inputDef = null;
        try (SystemInputResource reader = (SystemInputResource)Resource.withDefaultType((Resource)SystemInputResource.of((File)inputDefFile), (Resource.Type)defaultContentType);){
            inputDef = reader.getSystemInputDef();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't read input definition file=" + inputDefFile, e);
        }
        Anonymizer anonymizer = new Anonymizer(inputDef);
        SystemInputDef anonInputDef = anonymizer.getInputDef();
        logger_.info("Writing anonymized system input definition to {}", outputFile == null ? "standard output" : outputFile);
        FileOutputStream outputStream = null;
        try {
            outputStream = outputFile != null ? new FileOutputStream(outputFile) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't open output file=" + outputFile, e);
        }
        try {
            if (outputFileType == Resource.Type.JSON) {
                TcasesJson.writeInputModel((SystemInputDef)anonInputDef, (OutputStream)outputStream);
            } else {
                TcasesIO.writeInputModel((SystemInputDef)anonInputDef, (OutputStream)outputStream);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't write anonymized system input definition", e);
        }
        if (genOutFile != null) {
            logger_.info("Reading generator definition={}", (Object)genDefFile);
            IGeneratorSet genDef = null;
            try (GeneratorSetResource reader = (GeneratorSetResource)Resource.withDefaultType((Resource)GeneratorSetResource.of((File)genDefFile), (Resource.Type)genDefType);){
                genDef = reader.getGeneratorSet();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't read generator definition file=" + genDefFile, e);
            }
            IGeneratorSet anonGenDef = anonymizer.anonymize(genDef);
            logger_.info("Writing anonymized generator definition to {}", (Object)genOutFile);
            FileOutputStream genOutStream = null;
            try {
                genOutStream = new FileOutputStream(genOutFile);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't open output file=" + genOutFile, e);
            }
            Resource.Type genOutType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{Resource.Type.of((File)genOutFile), outputFileType});
            try {
                if (genOutType == Resource.Type.JSON) {
                    TcasesJson.writeGenerators((IGeneratorSet)anonGenDef, (OutputStream)genOutStream);
                } else {
                    TcasesIO.writeGenerators((IGeneratorSet)anonGenDef, (OutputStream)genOutStream);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can't write anonymized generator definition", e);
            }
        }
    }

    public static class Options {
        private File inputDef_;
        private File genDef_;
        private File workingDir_;
        private boolean showVersion_;
        private File outFile_;
        private Resource.Type contentType_;

        public Options() {
            this.setWorkingDir(null);
        }

        public Options(String[] args) {
            this();
            int i = 0;
            while (i < args.length && args[i].charAt(0) == '-') {
                i = this.handleOption(args, i);
            }
            this.handleArgs(args, i);
        }

        protected int handleOption(String[] args, int i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                this.throwHelpException();
            } else if (arg.equals("-v")) {
                this.setShowVersion(true);
            } else if (arg.equals("-f")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOutFile(new File(args[i]));
            } else if (arg.equals("-g")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setGenDef(new File(args[i]));
            } else if (arg.equals("-T")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setContentType(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid content type", e);
                }
            } else {
                CommandUtils.throwUsageException(String.format("Unknown option: %s", arg));
            }
            return i + 1;
        }

        protected void handleArgs(String[] args, int i) {
            int nargs = args.length - i;
            if (nargs > 1) {
                CommandUtils.throwUsageException(String.format("Unexpected argument: %s", args[i + 1]));
            }
            if (nargs > 0) {
                this.setInputDef(new File(args[i]));
            }
        }

        protected void throwHelpException() {
            this.printUsage();
            throw new HelpException();
        }

        protected void printUsage() {
            for (String line : new String[]{"Usage: tcases-anon [option...] [inputDef]", "", "Prints an anonymized version of a system input definition.", "", "The system input definition is read from the given inputDef. If omitted, the system input", "definition is read from standard input. Otherwise, the system input definition is read from", "the first one of the following files that can be located.", "", "  1. inputDef", "  2. inputDef-Input.xml", "  3. inputDef.xml", "", "Each option is one of the following:", "", "  -f outFile  If -f is defined, the anonymized system input definition is written to the given", "              outFile and anonymized generators are written to the same directory. If omitted,", "              the anonymized system input (only) is written to standard output.", "", "  -g genDef   If -g is defined, generators for the given inputDef are read from the given", "              genDef file. If omitted, generators are read from the corresponding *-Generators.xml", "              or *-Generators.json file (depending on the contentType) in the same directory as", "              the inputDef, if it exists.", "", "  -T contentType  Defines the default content type for the files read and produced.", "              The contentType must be one of 'json' or 'xml'. The default content type is", "              assumed for any file that is not specified explicitly or that does not have a", "              recognized extension. If omitted, the default content type is derived from the", "              inputDef name.", "", "  -l logFile  If -l is defined, log output is written to the given file. If omitted,", "              log output is written to a file named tcases-anon.log in the current working", "              directory. If logFile is 'stdout', log output is written to standard output.", "", "  -L logLevel Defines the level for log output. If omitted, the default level is INFO.", "              The configuration and levels used for logging are defined by the Logback system.", "", "  -v          Shows the current version. If this option is given, no other action is performed."}) {
                System.err.println(line);
            }
        }

        public void setInputDef(File inputDef) {
            this.inputDef_ = inputDef;
        }

        public File getInputDef() {
            return this.inputDef_;
        }

        public void setGenDef(File genDef) {
            this.genDef_ = genDef;
        }

        public File getGenDef() {
            return this.genDef_;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir_ = workingDir == null ? new File(".") : workingDir;
        }

        public File getWorkingDir() {
            return this.workingDir_;
        }

        public void setShowVersion(boolean showVersion) {
            this.showVersion_ = showVersion;
        }

        public boolean showVersion() {
            return this.showVersion_;
        }

        public void setOutFile(File outFile) {
            this.outFile_ = outFile;
        }

        public File getOutFile() {
            return this.outFile_;
        }

        public void setContentType(String option) {
            Resource.Type contentType = Resource.Type.of((String)option);
            if (option != null && contentType == null) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid content type", option));
            }
            this.setContentType(contentType);
        }

        public void setContentType(Resource.Type contentType) {
            this.contentType_ = contentType;
        }

        public Resource.Type getContentType() {
            return this.contentType_;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.getOutFile() != null) {
                builder.append(" -f ").append(this.getOutFile().getPath());
            }
            if (this.getGenDef() != null) {
                builder.append(" -g ").append(this.getGenDef().getPath());
            }
            if (this.getContentType() != null) {
                builder.append(" -T ").append(this.getContentType());
            }
            if (this.showVersion()) {
                builder.append(" -v");
            }
            return builder.toString();
        }

        public static class Builder {
            private Options options_ = new Options();

            public Builder inputDef(File inputDef) {
                this.options_.setInputDef(inputDef);
                return this;
            }

            public Builder genDef(File genDef) {
                this.options_.setGenDef(genDef);
                return this;
            }

            public Builder contentType(String type) {
                this.options_.setContentType(type);
                return this;
            }

            public Options build() {
                return this.options_;
            }
        }
    }
}

