/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class ButtonBarSkin
extends BehaviorSkinBase<ButtonBar, BehaviorBase<ButtonBar>> {
    private static final double GAP_SIZE = 10.0;
    private static final String CATEGORIZED_TYPES = "LRHEYNXBIACO";
    public static final String BUTTON_DATA_PROPERTY = "javafx.scene.control.ButtonBar.ButtonData";
    public static final String BUTTON_SIZE_INDEPENDENCE = "javafx.scene.control.ButtonBar.independentSize";
    private static final double DO_NOT_CHANGE_SIZE = Double.MAX_VALUE;
    private HBox layout = new HBox(10.0){

        protected void layoutChildren() {
            ButtonBarSkin.this.resizeButtons();
            super.layoutChildren();
        }
    };

    public ButtonBarSkin(ButtonBar control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.layout.setAlignment(Pos.CENTER);
        this.layout.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.layout);
        this.layoutButtons();
        control.getButtons().addListener(c -> this.layoutButtons());
        this.registerChangeListener((ObservableValue)control.buttonOrderProperty(), "BUTTON_ORDER");
        this.registerChangeListener((ObservableValue)control.buttonMinWidthProperty(), "BUTTON_MIN_WIDTH");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("BUTTON_ORDER".equals(p)) {
            this.layoutButtons();
        } else if ("BUTTON_MIN_WIDTH".equals(p)) {
            this.resizeButtons();
        }
    }

    private void layoutButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        ObservableList<Node> buttons = buttonBar.getButtons();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        Map<String, List<Node>> buttonMap = this.buildButtonMap((List<? extends Node>)buttons);
        String buttonOrder = ((ButtonBar)this.getSkinnable()).getButtonOrder();
        if (buttonOrder == null || buttonOrder.isEmpty()) {
            throw new IllegalStateException("ButtonBar buttonOrder string can not be null or empty");
        }
        char[] buttonOrderArr = buttonOrder.toCharArray();
        this.layout.getChildren().clear();
        int buttonIndex = 0;
        Spacer spacer = Spacer.NONE;
        for (int i = 0; i < buttonOrderArr.length; ++i) {
            boolean hasChildren;
            char type = buttonOrderArr[i];
            boolean edgeCase = buttonIndex <= 0 && buttonIndex >= buttons.size() - 1;
            boolean bl = hasChildren = !this.layout.getChildren().isEmpty();
            if (type == '+') {
                spacer = spacer.replace(Spacer.DYNAMIC);
                continue;
            }
            if (type == '_' && hasChildren) {
                spacer = spacer.replace(Spacer.FIXED);
                continue;
            }
            List<Node> buttonList = buttonMap.get(String.valueOf(type).toUpperCase());
            if (buttonList == null) continue;
            spacer.add((Pane)this.layout, edgeCase);
            for (Node btn : buttonList) {
                this.sizeButton(btn, buttonMinWidth, Double.MAX_VALUE, Double.MAX_VALUE);
                this.layout.getChildren().add((Object)btn);
                HBox.setHgrow((Node)btn, (Priority)Priority.NEVER);
                ++buttonIndex;
            }
            spacer = spacer.replace(Spacer.NONE);
        }
    }

    private void resizeButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        ObservableList<Node> buttons = buttonBar.getButtons();
        double widest = buttonMinWidth;
        for (Node button : buttons) {
            if (ButtonBar.isButtonUniformSize(button)) continue;
            widest = Math.max(button.prefWidth(-1.0), widest);
        }
        for (Node button : buttons) {
            if (ButtonBar.isButtonUniformSize(button)) continue;
            this.sizeButton(button, Double.MAX_VALUE, widest, Double.MAX_VALUE);
        }
    }

    private void sizeButton(Node btn, double min, double pref, double max) {
        if (btn instanceof Region) {
            Region regionBtn = (Region)btn;
            if (min != Double.MAX_VALUE) {
                regionBtn.setMinWidth(min);
            }
            if (pref != Double.MAX_VALUE) {
                regionBtn.setPrefWidth(pref);
            }
            if (max != Double.MAX_VALUE) {
                regionBtn.setMaxWidth(max);
            }
        }
    }

    private String getButtonType(Node btn) {
        String typeCode;
        ButtonBar.ButtonData buttonType = (ButtonBar.ButtonData)((Object)btn.getProperties().get((Object)BUTTON_DATA_PROPERTY));
        if (buttonType == null) {
            buttonType = ButtonBar.ButtonData.OTHER;
        }
        typeCode = (typeCode = buttonType.getTypeCode()).length() > 0 ? typeCode.substring(0, 1) : "";
        return CATEGORIZED_TYPES.contains(typeCode.toUpperCase()) ? typeCode : ButtonBar.ButtonData.OTHER.getTypeCode();
    }

    private Map<String, List<Node>> buildButtonMap(List<? extends Node> buttons) {
        HashMap<String, List<Node>> buttonMap = new HashMap<String, List<Node>>();
        for (Node node : buttons) {
            if (node == null) continue;
            String type = this.getButtonType(node);
            ArrayList<Node> typedButtons = (ArrayList<Node>)buttonMap.get(type);
            if (typedButtons == null) {
                typedButtons = new ArrayList<Node>();
                buttonMap.put(type, typedButtons);
            }
            typedButtons.add(node);
        }
        return buttonMap;
    }

    private static enum Spacer {
        FIXED{

            @Override
            protected Node create(boolean edgeCase) {
                if (edgeCase) {
                    return null;
                }
                Region spacer = new Region();
                spacer.setMinWidth(10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.NEVER);
                return spacer;
            }
        }
        ,
        DYNAMIC{

            @Override
            protected Node create(boolean edgeCase) {
                Region spacer = new Region();
                spacer.setMinWidth(edgeCase ? 0.0 : 10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                return spacer;
            }

            @Override
            public Spacer replace(Spacer spacer) {
                return FIXED == spacer ? this : spacer;
            }
        }
        ,
        NONE;


        protected Node create(boolean edgeCase) {
            return null;
        }

        public Spacer replace(Spacer spacer) {
            return spacer;
        }

        public void add(Pane pane, boolean edgeCase) {
            Node spacer = this.create(edgeCase);
            if (spacer != null) {
                pane.getChildren().add((Object)spacer);
            }
        }
    }
}

