/*
 * Decompiled with CFR 0.152.
 */
package libcore.javax.net.ssl;

import java.io.PrintStream;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import libcore.java.io.NullPrintStream;
import libcore.java.security.StandardNames;

public final class TestTrustManager
extends X509ExtendedTrustManager {
    private static final boolean LOG = false;
    private static final PrintStream out = new NullPrintStream();
    private final X509TrustManager trustManager;
    private final X509ExtendedTrustManager extendedTrustManager;

    public static TrustManager[] wrap(TrustManager[] trustManagers) {
        TrustManager[] result = (TrustManager[])trustManagers.clone();
        for (int i = 0; i < result.length; ++i) {
            result[i] = TestTrustManager.wrap(result[i]);
        }
        return result;
    }

    public static TrustManager wrap(TrustManager trustManager) {
        if (trustManager instanceof X509ExtendedTrustManager) {
            return new TestTrustManager((X509ExtendedTrustManager)trustManager);
        }
        if (trustManager instanceof X509TrustManager) {
            return new TestTrustManager((X509TrustManager)trustManager);
        }
        return trustManager;
    }

    public TestTrustManager(X509ExtendedTrustManager trustManager) {
        out.println("TestTrustManager.<init> extendedTrustManager=" + trustManager);
        this.extendedTrustManager = trustManager;
        this.trustManager = trustManager;
    }

    public TestTrustManager(X509TrustManager trustManager) {
        out.println("TestTrustManager.<init> trustManager=" + trustManager);
        this.extendedTrustManager = null;
        this.trustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        out.print("TestTrustManager.checkClientTrusted chain=" + chain.length + " authType=" + authType + " ");
        try {
            this.assertClientAuthType(authType);
            this.trustManager.checkClientTrusted(chain, authType);
            out.println("OK");
        }
        catch (CertificateException e) {
            e.printStackTrace(out);
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (this.extendedTrustManager == null) {
            out.print("(fallback to X509TrustManager) ");
            this.checkClientTrusted(chain, authType);
            return;
        }
        out.print("TestTrustManager.checkClientTrusted chain=" + chain.length + " authType=" + authType + " socket=" + socket + " ");
        try {
            this.assertClientAuthType(authType);
            this.extendedTrustManager.checkClientTrusted(chain, authType, socket);
            out.println("OK");
        }
        catch (CertificateException e) {
            e.printStackTrace(out);
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (this.extendedTrustManager == null) {
            out.print("(fallback to X509TrustManager) ");
            this.checkClientTrusted(chain, authType);
            return;
        }
        out.print("TestTrustManager.checkClientTrusted chain=" + chain.length + " authType=" + authType + " engine=" + engine + " ");
        try {
            this.assertClientAuthType(authType);
            this.extendedTrustManager.checkClientTrusted(chain, authType, engine);
            out.println("OK");
        }
        catch (CertificateException e) {
            e.printStackTrace(out);
            throw e;
        }
    }

    private void assertClientAuthType(String authType) {
        if (!StandardNames.CLIENT_AUTH_TYPES.contains(authType)) {
            throw new AssertionError((Object)("Unexpected client auth type " + authType));
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        out.print("TestTrustManager.checkServerTrusted chain=" + chain.length + " authType=" + authType + " ");
        try {
            this.assertServerAuthType(authType);
            this.trustManager.checkServerTrusted(chain, authType);
            out.println("OK");
        }
        catch (CertificateException e) {
            e.printStackTrace(out);
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (this.extendedTrustManager == null) {
            out.print("(fallback to X509TrustManager) ");
            this.checkServerTrusted(chain, authType);
            return;
        }
        out.print("TestTrustManager.checkServerTrusted chain=" + chain.length + " authType=" + authType + " socket=" + socket.toString() + " ");
        try {
            this.assertServerAuthType(authType);
            this.extendedTrustManager.checkServerTrusted(chain, authType, socket);
            out.println("OK");
        }
        catch (CertificateException e) {
            e.printStackTrace(out);
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        if (this.extendedTrustManager == null) {
            out.print("(fallback to X509TrustManager) ");
            this.checkServerTrusted(chain, authType);
            return;
        }
        out.print("TestTrustManager.checkServerTrusted chain=" + chain.length + " authType=" + authType + " engine=" + engine.toString() + " ");
        try {
            this.assertServerAuthType(authType);
            this.extendedTrustManager.checkServerTrusted(chain, authType, engine);
            out.println("OK");
        }
        catch (CertificateException e) {
            e.printStackTrace(out);
            throw e;
        }
    }

    private void assertServerAuthType(String authType) {
        if (!StandardNames.SERVER_AUTH_TYPES.contains(authType)) {
            throw new AssertionError((Object)("Unexpected server auth type " + authType));
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] result = this.trustManager.getAcceptedIssuers();
        out.print("TestTrustManager.getAcceptedIssuers result=" + result.length);
        return result;
    }
}

