/*
 * Decompiled with CFR 0.152.
 */
package libcore.javax.net.ssl;

import java.io.PrintStream;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import libcore.java.io.NullPrintStream;
import libcore.java.security.StandardNames;

public final class TestKeyManager
extends X509ExtendedKeyManager {
    private static final boolean LOG = false;
    private static final PrintStream out = new NullPrintStream();
    private final X509ExtendedKeyManager keyManager;

    public static KeyManager[] wrap(KeyManager[] keyManagers) {
        KeyManager[] result = (KeyManager[])keyManagers.clone();
        for (int i = 0; i < result.length; ++i) {
            result[i] = TestKeyManager.wrap(result[i]);
        }
        return result;
    }

    public static KeyManager wrap(KeyManager keyManager) {
        if (!(keyManager instanceof X509ExtendedKeyManager)) {
            return keyManager;
        }
        return new TestKeyManager((X509ExtendedKeyManager)keyManager);
    }

    public TestKeyManager(X509ExtendedKeyManager keyManager) {
        out.println("TestKeyManager.<init> keyManager=" + keyManager);
        this.keyManager = keyManager;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        out.print("TestKeyManager.chooseClientAlias");
        out.print(" | keyTypes: ");
        for (String keyType : keyTypes) {
            out.print(keyType);
            out.print(' ');
        }
        this.dumpIssuers(issuers);
        this.dumpSocket(socket);
        this.assertKeyTypes(keyTypes);
        return this.dumpAlias(this.keyManager.chooseClientAlias(keyTypes, issuers, socket));
    }

    private void assertKeyTypes(String[] keyTypes) {
        for (String keyType : keyTypes) {
            this.assertKeyType(keyType);
        }
    }

    private void assertKeyType(String keyType) {
        if (!StandardNames.KEY_TYPES.contains(keyType)) {
            throw new AssertionError((Object)("Unexpected key type " + keyType));
        }
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        out.print("TestKeyManager.chooseServerAlias");
        out.print(" | keyType: ");
        out.print(keyType);
        out.print(' ');
        this.dumpIssuers(issuers);
        this.dumpSocket(socket);
        this.assertKeyType(keyType);
        return this.dumpAlias(this.keyManager.chooseServerAlias(keyType, issuers, socket));
    }

    private void dumpSocket(Socket socket) {
        out.print(" | socket: ");
        out.print(String.valueOf(socket));
    }

    private void dumpIssuers(Principal[] issuers) {
        out.print(" | issuers: ");
        if (issuers == null) {
            out.print("null");
            return;
        }
        for (Principal issuer : issuers) {
            out.print(issuer);
            out.print(' ');
        }
    }

    private String dumpAlias(String alias) {
        out.print(" => ");
        out.println(alias);
        return alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        out.print("TestKeyManager.getCertificateChain");
        out.print(" | alias: ");
        out.print(alias);
        return this.dumpCerts(this.keyManager.getCertificateChain(alias));
    }

    private X509Certificate[] dumpCerts(X509Certificate[] certs) {
        out.print(" => ");
        for (X509Certificate cert : certs) {
            out.print(cert.getSubjectDN());
            out.print(' ');
        }
        out.println();
        return certs;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        out.print("TestKeyManager.getClientAliases");
        out.print(" | keyType: ");
        out.print(keyType);
        this.dumpIssuers(issuers);
        this.assertKeyType(keyType);
        return this.dumpAliases(this.keyManager.getClientAliases(keyType, issuers));
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        out.print("TestKeyManager.getServerAliases");
        out.print(" | keyType: ");
        out.print(keyType);
        this.dumpIssuers(issuers);
        this.assertKeyType(keyType);
        return this.dumpAliases(this.keyManager.getServerAliases(keyType, issuers));
    }

    private String[] dumpAliases(String[] aliases) {
        out.print(" => ");
        for (String alias : aliases) {
            out.print(alias);
            out.print(' ');
        }
        out.println();
        return aliases;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        out.print("TestKeyManager.getPrivateKey");
        out.print(" | alias: ");
        out.print(alias);
        PrivateKey pk = this.keyManager.getPrivateKey(alias);
        out.print(" => ");
        out.println(String.valueOf(pk));
        return pk;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine e) {
        out.print("TestKeyManager.chooseEngineClientAlias");
        out.print(" | keyTypes: ");
        for (String keyType : keyTypes) {
            out.print(keyType);
            out.print(' ');
        }
        this.dumpIssuers(issuers);
        this.dumpEngine(e);
        this.assertKeyTypes(keyTypes);
        return this.dumpAlias(this.keyManager.chooseEngineClientAlias(keyTypes, issuers, e));
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine e) {
        out.print("TestKeyManager.chooseEngineServerAlias");
        out.print(" | keyType: ");
        out.print(keyType);
        out.print(' ');
        this.dumpIssuers(issuers);
        this.dumpEngine(e);
        this.assertKeyType(keyType);
        return this.dumpAlias(this.keyManager.chooseEngineServerAlias(keyType, issuers, e));
    }

    private void dumpEngine(SSLEngine engine) {
        out.print(" | engine: ");
        out.print(String.valueOf(engine));
    }
}

