/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

final class SSLUtils {
    static final boolean USE_ENGINE_SOCKET_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("org.conscrypt.useEngineSocketByDefault"));
    private static final int MAX_PROTOCOL_LENGTH = 255;
    private static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 85;
    private static final int MAX_ENCRYPTION_OVERHEAD_DIFF = 0x7FFFFFAA;

    static int calculateOutNetBufSize(int pendingBytes) {
        return Math.min(16709, 85 + Math.min(0x7FFFFFAA, pendingBytes));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable e) {
        if (e instanceof SSLHandshakeException) {
            return (SSLHandshakeException)e;
        }
        return (SSLHandshakeException)new SSLHandshakeException(e.getMessage()).initCause(e);
    }

    static SSLException toSSLException(Throwable e) {
        if (e instanceof SSLException) {
            return (SSLException)e;
        }
        return new SSLException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getEncryptedPacketLength(ByteBuffer[] buffers, int offset) {
        ByteBuffer buffer = buffers[offset];
        if (buffer.remaining() >= 5) {
            return SSLUtils.getEncryptedPacketLength(buffer);
        }
        ByteBuffer tmp = ByteBuffer.allocate(5);
        do {
            buffer = buffers[offset++];
            int pos = buffer.position();
            int limit = buffer.limit();
            if (buffer.remaining() > tmp.remaining()) {
                buffer.limit(pos + tmp.remaining());
            }
            try {
                tmp.put(buffer);
            }
            finally {
                buffer.limit(limit);
                buffer.position(pos);
            }
        } while (tmp.hasRemaining());
        tmp.flip();
        return SSLUtils.getEncryptedPacketLength(tmp);
    }

    static byte[] toLengthPrefixedList(String ... protocols) {
        int length = 0;
        for (int i = 0; i < protocols.length; ++i) {
            int protocolLength = protocols[i].length();
            if (protocolLength == 0 || protocolLength > 255) {
                throw new IllegalArgumentException("Protocol has invalid length (" + protocolLength + "): " + protocols[i]);
            }
            length += 1 + protocolLength;
        }
        byte[] data = new byte[length];
        int dataIndex = 0;
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            int protocolLength = protocol.length();
            data[dataIndex++] = (byte)protocolLength;
            for (int ci = 0; ci < protocolLength; ++ci) {
                char c = protocol.charAt(ci);
                if (c > '\u007f') {
                    throw new IllegalArgumentException("Protocol contains invalid character: " + c + "(protocol=" + protocol + ")");
                }
                data[dataIndex++] = (byte)c;
            }
        }
        return data;
    }

    private static int getEncryptedPacketLength(ByteBuffer buffer) {
        int packetLength = 0;
        int pos = buffer.position();
        switch (SSLUtils.unsignedByte(buffer.get(pos))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                return -1;
            }
        }
        short majorVersion = SSLUtils.unsignedByte(buffer.get(pos + 1));
        if (majorVersion != 3) {
            return -1;
        }
        packetLength = SSLUtils.unsignedShort(buffer.getShort(pos + 3)) + 5;
        if (packetLength <= 5) {
            return -1;
        }
        return packetLength;
    }

    private static short unsignedByte(byte b) {
        return (short)(b & 0xFF);
    }

    private static int unsignedShort(short s) {
        return s & 0xFFFF;
    }

    private SSLUtils() {
    }
}

