/* Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. */

/* This file was generated by generate_constants.cc. */

package org.conscrypt;

final class NativeConstants {
    static final boolean HAS_EVP_AEAD = true;
    static final int OPENSSL_EC_NAMED_CURVE = 0;
    static final int POINT_CONVERSION_COMPRESSED = 2;
    static final int POINT_CONVERSION_UNCOMPRESSED = 4;
    static final int EXFLAG_CA = 16;
    static final int EXFLAG_CRITICAL = 512;
    static final int EVP_PKEY_RSA = 6;
    static final int EVP_PKEY_EC = 408;
    static final int RSA_PKCS1_PADDING = 1;
    static final int RSA_NO_PADDING = 3;
    static final int RSA_PKCS1_OAEP_PADDING = 4;
    static final int RSA_PKCS1_PSS_PADDING = 6;
    static final int SSL_MODE_SEND_FALLBACK_SCSV = 1024;
    static final int SSL_MODE_CBC_RECORD_SPLITTING = 256;
    static final int SSL_MODE_ENABLE_FALSE_START = 128;
    static final int SSL_OP_CIPHER_SERVER_PREFERENCE = 4194304;
    static final int SSL_OP_NO_TICKET = 16384;
    static final int SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 0;
    static final int SSL_OP_NO_SSLv3 = 33554432;
    static final int SSL_OP_NO_TLSv1 = 67108864;
    static final int SSL_OP_NO_TLSv1_1 = 268435456;
    static final int SSL_OP_NO_TLSv1_2 = 134217728;
    static final int SSL_ERROR_NONE = 0;
    static final int SSL_ERROR_WANT_READ = 2;
    static final int SSL_ERROR_WANT_WRITE = 3;
    static final int SSL_ERROR_ZERO_RETURN = 6;
    static final int SSL_SENT_SHUTDOWN = 1;
    static final int SSL_RECEIVED_SHUTDOWN = 2;
    static final int TLS_CT_RSA_SIGN = 1;
    static final int TLS_CT_ECDSA_SIGN = 64;
    static final int TLS_CT_RSA_FIXED_DH = 3;
    static final int TLS_CT_RSA_FIXED_ECDH = 65;
    static final int TLS_CT_ECDSA_FIXED_ECDH = 66;
    static final int SSL_VERIFY_NONE = 0;
    static final int SSL_VERIFY_PEER = 1;
    static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = 2;
    static final int SSL_ST_CONNECT = 4096;
    static final int SSL_ST_ACCEPT = 8192;
    static final int SSL_ST_MASK = 4095;
    static final int SSL_ST_INIT = 12288;
    static final int SSL_ST_OK = 3;
    static final int SSL_ST_RENEGOTIATE = 12292;
    static final int SSL_CB_LOOP = 1;
    static final int SSL_CB_EXIT = 2;
    static final int SSL_CB_READ = 4;
    static final int SSL_CB_WRITE = 8;
    static final int SSL_CB_ALERT = 16384;
    static final int SSL_CB_READ_ALERT = 16388;
    static final int SSL_CB_WRITE_ALERT = 16392;
    static final int SSL_CB_ACCEPT_LOOP = 8193;
    static final int SSL_CB_ACCEPT_EXIT = 8194;
    static final int SSL_CB_CONNECT_LOOP = 4097;
    static final int SSL_CB_CONNECT_EXIT = 4098;
    static final int SSL_CB_HANDSHAKE_START = 16;
    static final int SSL_CB_HANDSHAKE_DONE = 32;
    static final int SSL3_RT_MAX_PLAIN_LENGTH = 16384;
    static final int SSL3_RT_MAX_PACKET_SIZE = 16709;
    static final int SSL3_RT_CHANGE_CIPHER_SPEC = 20;
    static final int SSL3_RT_ALERT = 21;
    static final int SSL3_RT_HANDSHAKE = 22;
    static final int SSL3_RT_APPLICATION_DATA = 23;
    static final int SSL3_RT_HEADER_LENGTH = 5;
}
