/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import org.conscrypt.AlpnProtocolSelector;
import org.conscrypt.Preconditions;

final class AlpnProtocolSelectorAdapter {
    private static final int NO_PROTOCOL_SELECTED = -1;
    private final SSLEngine engine;
    private final SSLSocket socket;
    private final AlpnProtocolSelector selector;

    AlpnProtocolSelectorAdapter(SSLEngine engine, AlpnProtocolSelector selector) {
        this.engine = Preconditions.checkNotNull(engine, "engine");
        this.socket = null;
        this.selector = Preconditions.checkNotNull(selector, "selector");
    }

    AlpnProtocolSelectorAdapter(SSLSocket socket, AlpnProtocolSelector selector) {
        this.engine = null;
        this.socket = Preconditions.checkNotNull(socket, "socket");
        this.selector = Preconditions.checkNotNull(selector, "selector");
    }

    int selectAlpnProtocol(byte[] lengthPrefixedList) {
        byte protocolLength;
        if (lengthPrefixedList == null || lengthPrefixedList.length == 0) {
            return -1;
        }
        ArrayList<String> stringProtocols = new ArrayList<String>();
        for (int i = 0; i < lengthPrefixedList.length; i += protocolLength) {
            protocolLength = lengthPrefixedList[i++];
            Charset US_ASCII = Charset.forName("US-ASCII");
            stringProtocols.add(new String(lengthPrefixedList, i, (int)protocolLength, US_ASCII));
        }
        String selected = this.engine != null ? this.selector.selectAlpnProtocol(this.engine, stringProtocols) : this.selector.selectAlpnProtocol(this.socket, stringProtocols);
        if (selected == null || selected.isEmpty()) {
            return -1;
        }
        int offset = 0;
        for (String protocol : stringProtocols) {
            if (selected.equals(protocol)) {
                return offset;
            }
            offset += 1 + protocol.length();
        }
        return -1;
    }
}

