/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SyncApiOpTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(SyncApiOpTests.class);
    private static final String TEST_NAME = "Sync";
    public static final String MODIFIED = "modified";
    private static final String DISABLE = "disable";
    private static final String CREATE_PREFIX = "create";
    private static final String UPDATE_PREFIX = "update";
    private static final String DELETE_PREFIX = "delete";

    public SyncApiOpTests(ObjectClass oclass) {
        super(oclass);
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(SyncApiOp.class);
        s.add(CreateApiOp.class);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRun() {
        Uid uid = null;
        Set<Attribute> attrs = null;
        List<SyncDelta> deltas = null;
        SyncToken token = null;
        String msg = null;
        try {
            Set<Attribute> replaceAttributes;
            token = this.getConnectorFacade().getLatestSyncToken(this.getObjectClass());
            attrs = ConnectorHelper.getCreateableAttributes(SyncApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
            uid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
            Assert.assertNotNull((String)"Create returned null uid.", (Object)uid);
            if (SyncApiOpTests.canSyncAfterOp(CreateApiOp.class)) {
                deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, this.getOperationOptionsByOp(SyncApiOp.class));
                msg = "Sync should have returned one sync delta after creation of one object, but returned: %d";
                Assert.assertTrue((String)String.format(msg, deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
                ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(0), uid, attrs, SyncDeltaType.CREATE_OR_UPDATE, true);
                token = deltas.get(0).getToken();
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), UpdateApiOp.class) && SyncApiOpTests.canSyncAfterOp(UpdateApiOp.class) && (replaceAttributes = ConnectorHelper.getUpdateableAttributes(SyncApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), MODIFIED, 0, false, false)).size() > 0) {
                replaceAttributes.add((Attribute)uid);
                Assert.assertTrue((String)"no update attributes were found", (replaceAttributes.size() > 0 ? 1 : 0) != 0);
                Uid newUid = this.getConnectorFacade().update(this.getSupportedObjectClass(), uid, AttributeUtil.filterUid(replaceAttributes), this.getOperationOptionsByOp(UpdateApiOp.class));
                if (!newUid.equals((Object)uid)) {
                    replaceAttributes.remove(uid);
                    replaceAttributes.add((Attribute)newUid);
                    uid = newUid;
                }
                deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, this.getOperationOptionsByOp(SyncApiOp.class));
                msg = "Sync should have returned one sync delta after update of one object, but returned: %d";
                Assert.assertTrue((String)String.format(msg, deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
                ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(0), uid, replaceAttributes, SyncDeltaType.CREATE_OR_UPDATE, true);
                token = deltas.get(0).getToken();
            }
            if (SyncApiOpTests.canSyncAfterOp(DeleteApiOp.class)) {
                this.getConnectorFacade().delete(this.getObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
                deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, this.getOperationOptionsByOp(SyncApiOp.class));
                msg = "Sync should have returned one sync delta after delete of one object, but returned: %d";
                Assert.assertTrue((String)String.format(msg, deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
                ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(0), uid, null, SyncDeltaType.DELETE, true);
            }
        }
        catch (Throwable throwable) {
            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
            throw throwable;
        }
        ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncWithoutAttrsToGet() {
        block3: {
            block2: {
                if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations()) || !SyncApiOpTests.canSyncAfterOp(CreateApiOp.class)) break block2;
                Uid uid = null;
                try {
                    SyncToken token = this.getConnectorFacade().getLatestSyncToken(this.getObjectClass());
                    Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(SyncApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 1, true, false);
                    uid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, null);
                    Assert.assertNotNull((String)"Create returned null uid.", (Object)uid);
                    List<SyncDelta> deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getSupportedObjectClass(), token, null);
                    String MSG = "Sync should have returned one sync delta after creation of one object, but returned: %d";
                    Assert.assertTrue((String)String.format("Sync should have returned one sync delta after creation of one object, but returned: %d", deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
                    ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(0), uid, attrs, SyncDeltaType.CREATE_OR_UPDATE, false);
                }
                catch (Throwable throwable) {
                    this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, null);
                    throw throwable;
                }
                this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, null);
                break block3;
            }
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testSyncWithoutAttrsToGet'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatestSyncToken() {
        block3: {
            block2: {
                if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations()) || !SyncApiOpTests.canSyncAfterOp(CreateApiOp.class)) break block2;
                Uid uid1 = null;
                Uid uid2 = null;
                try {
                    Set<Attribute> attrs1 = ConnectorHelper.getCreateableAttributes(SyncApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 2, true, false);
                    uid1 = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs1, null);
                    Assert.assertNotNull((String)"Create returned null uid.", (Object)uid1);
                    SyncToken latestToken = this.getConnectorFacade().getLatestSyncToken(this.getObjectClass());
                    final LinkedList deltas = new LinkedList();
                    this.getConnectorFacade().sync(this.getObjectClass(), latestToken, new SyncResultsHandler(){

                        public boolean handle(SyncDelta delta) {
                            deltas.add(delta);
                            return true;
                        }
                    }, null);
                    String MSG1 = "Sync with previously retrieved latest sync token should not return any deltas, but returned: %d.";
                    Assert.assertTrue((String)String.format("Sync with previously retrieved latest sync token should not return any deltas, but returned: %d.", deltas.size()), (deltas.size() == 0 ? 1 : 0) != 0);
                    Set<Attribute> attrs2 = ConnectorHelper.getCreateableAttributes(SyncApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 3, true, false);
                    uid2 = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs2, null);
                    Assert.assertNotNull((String)"Create returned null uid.", (Object)uid2);
                    this.getConnectorFacade().sync(this.getObjectClass(), latestToken, new SyncResultsHandler(){

                        public boolean handle(SyncDelta delta) {
                            deltas.add(delta);
                            return true;
                        }
                    }, null);
                    String MSG2 = "Sync with latest sync token retrieved before one create should return one sync delta, but returned: %d";
                    Assert.assertTrue((String)String.format("Sync with latest sync token retrieved before one create should return one sync delta, but returned: %d", deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
                    ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), (SyncDelta)deltas.get(0), uid2, attrs2, SyncDeltaType.CREATE_OR_UPDATE, false);
                }
                catch (Throwable throwable) {
                    this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid1, null);
                    this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid2, null);
                    throw throwable;
                }
                this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid1, null);
                this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid2, null);
                break block3;
            }
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testLatestSyncToken'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }

    protected static boolean canSyncAfterOp(Class<? extends APIOperation> operation) {
        Boolean canSync = true;
        try {
            if (operation.equals(CreateApiOp.class)) {
                canSync = (Boolean)SyncApiOpTests.getDataProvider().getTestSuiteAttribute("disable.create", TEST_NAME) == false;
            } else if (operation.equals(UpdateApiOp.class)) {
                canSync = (Boolean)SyncApiOpTests.getDataProvider().getTestSuiteAttribute("disable.update", TEST_NAME) == false;
            } else if (operation.equals(DeleteApiOp.class)) {
                canSync = (Boolean)SyncApiOpTests.getDataProvider().getTestSuiteAttribute("disable.delete", TEST_NAME) == false;
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return canSync;
    }
}

