/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchApiOpTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(SearchApiOpTests.class);
    private static final String TEST_NAME = "Search";
    private static final String CASE_INSENSITIVE_PREFIX = "caseinsensitive";
    private static final String DISABLE = "disable";
    private static final String COMPARE_BY_UID_ONLY = "compareExistingObjectsByUidOnly";

    public SearchApiOpTests(ObjectClass oclass) {
        super(oclass);
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> requiredOps = new HashSet<Class<? extends APIOperation>>();
        requiredOps.add(CreateApiOp.class);
        requiredOps.add(SearchApiOp.class);
        requiredOps.add(GetApiOp.class);
        return requiredOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRun() {
        Uid uid = null;
        ArrayList<Uid> uids = new ArrayList<Uid>();
        ArrayList<Set<Attribute>> attrs = new ArrayList<Set<Attribute>>();
        ConnectorObject coFound = null;
        int recordCount = 10;
        try {
            Map<Uid, ConnectorObject> coBeforeTest = ConnectorHelper.search2Map(this.getConnectorFacade(), this.getObjectClass(), null, this.getOperationOptionsByOp(SearchApiOp.class));
            for (int i = 0; i < 10; ++i) {
                Set<Attribute> attr = ConnectorHelper.getCreateableAttributes(SearchApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), i, true, false);
                Uid luid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attr, this.getOperationOptionsByOp(CreateApiOp.class));
                Assert.assertNotNull((String)"Create returned null uid.", (Object)luid);
                attrs.add(attr);
                uids.add(luid);
            }
            List<ConnectorObject> coAll = ConnectorHelper.search(this.getConnectorFacade(), this.getObjectClass(), null, this.getOperationOptionsByOp(SearchApiOp.class));
            uid = (Uid)uids.get(0);
            Filter fltUid = FilterBuilder.equalTo((Attribute)uid);
            List<ConnectorObject> coObjects = ConnectorHelper.search(this.getConnectorFacade(), this.getObjectClass(), fltUid, this.getOperationOptionsByOp(SearchApiOp.class));
            Assert.assertTrue((String)("Search filter by uid failed, expected to return one object, but returned " + coObjects.size()), (coObjects.size() == 1 ? 1 : 0) != 0);
            coFound = coObjects.get(0);
            Set searchBy = (Set)attrs.get(0);
            ConnectorHelper.checkObject(this.getObjectClassInfo(), coFound, searchBy);
            Attribute attName = coFound.getAttributeByName(Name.NAME);
            Assert.assertTrue((String)"Special attribute NAME is expected to have exactly one value.", (attName.getValue().size() == 1 ? 1 : 0) != 0);
            String attNameValue = attName.getValue().get(0).toString();
            coFound = ConnectorHelper.findObjectByName(this.getConnectorFacade(), this.getObjectClass(), attNameValue, this.getOperationOptionsByOp(SearchApiOp.class));
            ConnectorHelper.checkObject(this.getObjectClassInfo(), coFound, searchBy);
            Filter fltAllAtts = null;
            HashSet<Attribute> filteredAttrs = new HashSet<Attribute>();
            for (Attribute attribute : searchBy) {
                if (AttributeUtil.isSpecial((Attribute)attribute) || !ConnectorHelper.isReadable(this.getObjectClassInfo(), attribute)) continue;
                fltAllAtts = fltAllAtts == null ? FilterBuilder.equalTo((Attribute)attribute) : FilterBuilder.and((Filter)fltAllAtts, (Filter)FilterBuilder.equalTo((Attribute)attribute));
                filteredAttrs.add(attribute);
            }
            if (fltAllAtts != null) {
                int count = 0;
                for (ConnectorObject co : coAll) {
                    if (!fltAllAtts.accept(co)) continue;
                    ++count;
                }
                coObjects = ConnectorHelper.search(this.getConnectorFacade(), this.getObjectClass(), fltAllAtts, this.getOperationOptionsByOp(SearchApiOp.class));
                Assert.assertEquals((String)("Search by all non-special attributes returned " + coObjects.size() + " objects, but expected was " + count + " ."), (long)count, (long)coObjects.size());
                for (ConnectorObject coChecked : coObjects) {
                    ConnectorHelper.checkObject(this.getObjectClassInfo(), coChecked, filteredAttrs);
                }
            }
            coObjects = ConnectorHelper.search(this.getConnectorFacade(), this.getObjectClass(), null, this.getOperationOptionsByOp(SearchApiOp.class));
            Assert.assertTrue((String)("Null-filter search failed, wrong number of objects returned, expected: " + (uids.size() + coBeforeTest.size()) + " but found: " + coObjects.size()), (coObjects.size() == uids.size() + coBeforeTest.size() ? 1 : 0) != 0);
            ArrayList tempUids = new ArrayList(uids);
            for (ConnectorObject cObject : coObjects) {
                int idx = uids.indexOf(cObject.getUid());
                if (idx > -1) {
                    Assert.assertTrue((boolean)tempUids.remove(cObject.getUid()));
                    ConnectorHelper.checkObject(this.getObjectClassInfo(), cObject, (Set)attrs.get(idx));
                    continue;
                }
                if (SearchApiOpTests.compareExistingObjectsByUidOnly()) {
                    Assert.assertTrue((String)"Object returned by null-filter search is neither in list of objects created by test nor in list of objects that were in connector resource before test. Objects were compared by Uid only.", (boolean)coBeforeTest.containsKey(cObject.getUid()));
                    continue;
                }
                Assert.assertTrue((String)"Object returned by null-filter search is neither in list of objects created by test nor in list of objects that were in connector resource before test. Objects were compared by all attributes.", (boolean)coBeforeTest.containsValue(cObject));
            }
            Assert.assertTrue((String)"Null-filter search didn't return all created objects by search test.", (tempUids.size() == 0 ? 1 : 0) != 0);
        }
        finally {
            for (Uid deluid : uids) {
                try {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), deluid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testSearchWithoutAttrsToGet() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            Uid uid = null;
            try {
                Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(SearchApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
                uid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, null);
                Assert.assertNotNull((String)"Create returned null uid.", (Object)uid);
                Filter fltUid = FilterBuilder.equalTo((Attribute)uid);
                List<ConnectorObject> coObjects = ConnectorHelper.search(this.getConnectorFacade(), this.getSupportedObjectClass(), fltUid, null);
                Assert.assertTrue((String)("Search filter by uid with no OperationOptions failed, expected to return one object, but returned " + coObjects.size()), (coObjects.size() == 1 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)coObjects.get(0));
                ConnectorHelper.checkObject(this.getObjectClassInfo(), coObjects.get(0), attrs, false);
                if (uid == null) return;
            }
            catch (Throwable throwable) {
                if (uid == null) throw throwable;
                this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, null);
                throw throwable;
            }
            this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, null);
            return;
        }
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        LOG.info("Skipping test ''testSearchWithoutAttrsToGet'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testCaseInsensitiveSearch() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations()) && SearchApiOpTests.canSearchCaseInsensitive()) {
            Uid uid = null;
            try {
                Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(SearchApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
                uid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, null);
                Assert.assertNotNull((String)"Create returned null uid.", (Object)uid);
                ConnectorObject searchResult = this.searchForUid(uid.getUidValue(), "[query by original uid]");
                String uidStr = uid.getUidValue();
                String caseChngd_uidStr = SearchApiOpTests.changeCase(uidStr);
                String name = this.getName(uid);
                String caseChngd_NAME = SearchApiOpTests.changeCase(name);
                ConnectorObject searchWithChngdCaseResult = this.searchForUid(caseChngd_uidStr, "[query by changed case uid]");
                Assert.assertTrue((String)"The search responses differ for changed case query [UID] and simple query.", (boolean)searchWithChngdCaseResult.equals((Object)searchResult));
                searchWithChngdCaseResult = this.searchForName(caseChngd_NAME, "[query by changed case name]");
                Assert.assertTrue((String)"The search responses differ for changed case query [NAME] and simple query.", (boolean)searchWithChngdCaseResult.equals((Object)searchResult));
                if (uid == null) return;
            }
            catch (Throwable throwable) {
                if (uid == null) throw throwable;
                this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, null);
                throw throwable;
            }
            this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, null);
            return;
        }
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        LOG.info("Skipping test ''testCaseInsensitiveSearch'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
    }

    private ConnectorObject searchForName(String caseChngd_NAME, String msg) {
        Filter fltUid = FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)Name.NAME, (Object[])new Object[]{caseChngd_NAME}));
        List<ConnectorObject> coObjects = ConnectorHelper.search(this.getConnectorFacade(), this.getSupportedObjectClass(), fltUid, null);
        Assert.assertTrue((String)(msg + " Search filter by uid with no OperationOptions failed, expected to return one object, but returned " + coObjects.size()), (coObjects.size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)coObjects.get(0));
        return coObjects.get(0);
    }

    private String getName(Uid uid) {
        OperationOptionsBuilder oob = new OperationOptionsBuilder();
        oob.setAttributesToGet(new String[]{Name.NAME});
        ConnectorObject o = this.getConnectorFacade().getObject(this.getObjectClass(), uid, oob.build());
        Attribute attrName = o.getAttributeByName(Name.NAME);
        return attrName.getValue().get(0).toString();
    }

    private ConnectorObject searchForUid(String uidValue, String msg) {
        Filter fltUid = FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)Uid.NAME, (Object[])new Object[]{uidValue}));
        List<ConnectorObject> coObjects = ConnectorHelper.search(this.getConnectorFacade(), this.getSupportedObjectClass(), fltUid, null);
        Assert.assertTrue((String)(msg + " Search filter by uid with no OperationOptions failed, expected to return one object, but returned " + coObjects.size()), (coObjects.size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)coObjects.get(0));
        return coObjects.get(0);
    }

    static String changeCase(String str_uid) {
        char[] result = new char[str_uid.length()];
        for (int i = 0; i < str_uid.length(); ++i) {
            result[i] = Character.isLowerCase(str_uid.charAt(i)) ? Character.toUpperCase(str_uid.charAt(i)) : Character.toLowerCase(str_uid.charAt(i));
        }
        return new String(result);
    }

    protected static boolean canSearchCaseInsensitive() {
        Boolean canSearchCIns = true;
        try {
            canSearchCIns = (Boolean)SearchApiOpTests.getDataProvider().getTestSuiteAttribute("disable.caseinsensitive", TEST_NAME) == false;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return canSearchCIns;
    }

    protected static boolean compareExistingObjectsByUidOnly() {
        boolean compareByUidOnly = false;
        try {
            compareByUidOnly = (Boolean)SearchApiOpTests.getDataProvider().getTestSuiteAttribute(COMPARE_BY_UID_ONLY, TEST_NAME);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return compareByUidOnly;
    }
}

