/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ContractTestBase;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.common.objects.ScriptContext;
import org.junit.Assert;
import org.junit.Test;

public class ScriptOnConnectorApiOpTests
extends ContractTestBase {
    private static final Log LOG = Log.getLog(ScriptOnConnectorApiOpTests.class);
    private static final String TEST_NAME = "ScriptOnConnector";
    private static final String LANGUAGE_PROP_PREFIX = "language";
    private static final String SCRIPT_PROP_PREFIX = "script";
    private static final String ARGUMENTS_PROP_PREFIX = "arguments";
    private static final String RESULT_PROP_PREFIX = "result";

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(ScriptOnConnectorApiOp.class);
        return s;
    }

    @Test
    public void testRunScript() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            try {
                String language = (String)ScriptOnConnectorApiOpTests.getDataProvider().getTestSuiteAttribute(LANGUAGE_PROP_PREFIX, TEST_NAME);
                String script = (String)ScriptOnConnectorApiOpTests.getDataProvider().getTestSuiteAttribute(SCRIPT_PROP_PREFIX, TEST_NAME);
                Map arguments = (Map)ScriptOnConnectorApiOpTests.getDataProvider().getTestSuiteAttribute(ARGUMENTS_PROP_PREFIX, TEST_NAME);
                Object expResult = ScriptOnConnectorApiOpTests.getDataProvider().getTestSuiteAttribute(RESULT_PROP_PREFIX, TEST_NAME);
                Object result = this.getConnectorFacade().runScriptOnConnector(new ScriptContext(language, script, arguments), this.getOperationOptionsByOp(ScriptOnConnectorApiOp.class));
                String MSG = "Script result was unexpected, expected: '%s', returned: '%s'.";
                Assert.assertEquals((String)String.format("Script result was unexpected, expected: '%s', returned: '%s'.", expResult, result), (Object)expResult, (Object)result);
            }
            catch (ObjectNotFoundException ex) {
                LOG.info("Test properties not set, skipping the test ScriptOnConnector", new Object[0]);
            }
        } else {
            LOG.info("---------------------------------", new Object[0]);
            LOG.info("Skipping test ''testRunScript''.", new Object[0]);
            LOG.info("---------------------------------", new Object[0]);
        }
    }

    @Test
    public void testRunScriptFailUnknownLanguage() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            try {
                this.getConnectorFacade().runScriptOnConnector(new ScriptContext("NONEXISTING LANGUAGE", SCRIPT_PROP_PREFIX, new HashMap()), null);
                Assert.fail((String)"Script language is not supported, should throw an exception.");
            }
            catch (RuntimeException runtimeException) {}
        } else {
            LOG.info("----------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testRunScriptFailUnknownLanguage''.", new Object[0]);
            LOG.info("----------------------------------------------------", new Object[0]);
        }
    }

    @Test
    public void testRunScriptFailEmptyScriptText() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            try {
                this.getConnectorFacade().runScriptOnConnector(new ScriptContext("LANGUAGE", "", new HashMap()), null);
                Assert.fail((String)"Script text is empty and script language is not probably supported, should throw an exception.");
            }
            catch (RuntimeException runtimeException) {}
        } else {
            LOG.info("----------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testRunScriptFailEmptyScriptText''.", new Object[0]);
            LOG.info("----------------------------------------------------", new Object[0]);
        }
    }
}

