/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ContractTestBase;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.SchemaApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.Assert;
import org.junit.Test;

public class SchemaApiOpTests
extends ContractTestBase {
    private static final String TEST_NAME = "Schema";
    private static final String SUPPORTED_OBJECT_CLASSES_PROPERTY_PREFIX = "oclasses";
    private static final String SUPPORTED_OPERATIONS_PROPERTY_PREFIX = "operations";
    private static final String STRICT_CHECK_PROPERTY_PREFIX = "strictCheck";
    private static final String ATTRIBUTE_FIELD_RETURNED_BY_DEFAULT = "returnedByDefault";
    private static final String ATTRIBUTE_FIELD_MULTI_VALUE = "multiValue";
    private static final String ATTRIBUTE_FIELD_REQUIRED = "required";
    private static final String ATTRIBUTE_FIELD_CREATEABLE = "createable";
    private static final String ATTRIBUTE_FIELD_UPDATEABLE = "updateable";
    private static final String ATTRIBUTE_FILED_READABLE = "readable";
    private static final String ATTRIBUTE_FIELD_TYPE = "type";
    private static final List<Class<? extends APIOperation>> opSupportedByAllOClasses = new LinkedList<Class<? extends APIOperation>>();

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(SchemaApiOp.class);
        return s;
    }

    @Test
    public void testUidNotPresent() {
        Schema schema = this.getConnectorFacade().schema();
        Set ocInfos = schema.getObjectClassInfo();
        for (ObjectClassInfo ocInfo : ocInfos) {
            Set attInfos = ocInfo.getAttributeInfo();
            for (AttributeInfo attInfo : attInfos) {
                Assert.assertTrue((String)"Uid can't be present in connector Schema!", (!attInfo.is(Uid.NAME) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNamePresent() {
        Schema schema = this.getConnectorFacade().schema();
        Set ocInfos = schema.getObjectClassInfo();
        for (ObjectClassInfo ocInfo : ocInfos) {
            Set attInfos = ocInfo.getAttributeInfo();
            boolean found = false;
            for (AttributeInfo attInfo : attInfos) {
                if (!attInfo.is(Name.NAME)) continue;
                found = true;
            }
            String MSG = "Name is not present among attributes of object class '%s'.";
            Assert.assertTrue((String)String.format("Name is not present among attributes of object class '%s'.", ocInfo.getType()), (boolean)found);
        }
    }

    @Test
    public void testOpSupportedByAllOClasses() {
        Schema schema = this.getConnectorFacade().schema();
        Set ocInfos = schema.getObjectClassInfo();
        for (Class<? extends APIOperation> apiOp : opSupportedByAllOClasses) {
            Set suppOClasses = schema.getSupportedObjectClassesByOperation(apiOp);
            if (suppOClasses.isEmpty()) continue;
            String MSG = "Operation %s must be in the schema supported by all object classes which supports connector.";
            Assert.assertTrue((String)String.format("Operation %s must be in the schema supported by all object classes which supports connector.", apiOp), (boolean)CollectionUtil.equals((Object)suppOClasses, (Object)ocInfos));
        }
    }

    @Test
    public void testSchemaExpected() {
        Schema schema = this.getConnectorFacade().schema();
        String msg = null;
        Boolean strictCheck = this.getStrictCheckProperty();
        List expOClasses = (List)this.getTestPropertyOrFail(List.class.getName(), SUPPORTED_OBJECT_CLASSES_PROPERTY_PREFIX, true);
        ArrayList<String> testedOClasses = new ArrayList<String>();
        for (ObjectClassInfo ocInfo : schema.getObjectClassInfo()) {
            boolean expected = expOClasses.contains(ocInfo.getType());
            if (strictCheck.booleanValue()) {
                msg = "Schema returned object class %s that is not expected to be suported.";
                Assert.assertTrue((String)String.format(msg, ocInfo.getType()), (boolean)expected);
            } else if (!expected) continue;
            testedOClasses.add(ocInfo.getType());
            List expAttrs = (List)this.getTestPropertyOrFail(List.class.getName(), "attributes." + ocInfo.getType() + "." + SUPPORTED_OBJECT_CLASSES_PROPERTY_PREFIX, strictCheck);
            for (AttributeInfo attr : ocInfo.getAttributeInfo()) {
                if (strictCheck.booleanValue()) {
                    msg = "Object class %s contains unexpected attribute: %s.";
                    Assert.assertTrue((String)String.format(msg, ocInfo.getType(), attr.getName()), (boolean)expAttrs.contains(attr.getName()));
                }
                Map expAttrValues = (Map)this.getTestPropertyOrFail(Map.class.getName(), attr.getName() + ".attribute." + ocInfo.getType() + "." + SUPPORTED_OBJECT_CLASSES_PROPERTY_PREFIX, strictCheck);
                if (!strictCheck.booleanValue() && expAttrValues == null) continue;
                this.checkAttributeValues(ocInfo, attr, expAttrValues);
            }
            for (String expAttr : expAttrs) {
                msg = "Schema doesn't contain expected attribute '%s' in object class '%s'.";
                Assert.assertNotNull((String)String.format(msg, expAttr, ocInfo.getType()), (Object)AttributeInfoUtil.find((String)expAttr, (Set)ocInfo.getAttributeInfo()));
            }
        }
        HashSet notFoundOClasses = new HashSet(expOClasses);
        notFoundOClasses.removeAll(testedOClasses);
        if (!notFoundOClasses.isEmpty()) {
            msg = "Schema did not contain expected object class %s.";
            Assert.fail((String)String.format(msg, notFoundOClasses.iterator().next()));
        }
        Map expOperations = (Map)this.getTestPropertyOrFail(Map.class.getName(), SUPPORTED_OPERATIONS_PROPERTY_PREFIX, true);
        Map supportedOperations = schema.getSupportedObjectClassesByOperation();
        ArrayList<String> testedOps = new ArrayList<String>();
        for (Class operation : supportedOperations.keySet()) {
            boolean expectedOp = expOperations.containsKey(operation.getSimpleName());
            if (strictCheck.booleanValue()) {
                msg = "Schema returned unexpected operation: %s.";
                Assert.assertTrue((String)String.format(msg, operation.getSimpleName()), (boolean)expectedOp);
            } else if (!expectedOp) continue;
            testedOps.add(operation.getSimpleName());
            List expOClassesForOp = (List)expOperations.get(operation.getSimpleName());
            Assert.assertNotNull((Object)expOClassesForOp);
            ArrayList<String> testedOClassesForOp = new ArrayList<String>();
            for (ObjectClassInfo ocInfo : (Set)supportedOperations.get(operation)) {
                boolean expectedOClassForOp = expOClassesForOp.contains(ocInfo.getType());
                if (strictCheck.booleanValue()) {
                    msg = "Operation %s supports unexpected object class: %s.";
                    Assert.assertTrue((String)String.format(msg, operation.getSimpleName(), ocInfo.getType()), (boolean)expectedOClassForOp);
                } else if (!expectedOClassForOp) continue;
                testedOClassesForOp.add(ocInfo.getType());
            }
            HashSet notFoundOClassesForOp = new HashSet(expOClassesForOp);
            notFoundOClassesForOp.removeAll(testedOClassesForOp);
            if (notFoundOClassesForOp.isEmpty()) continue;
            msg = "Operation %s is not supported by object class %s.";
            Assert.fail((String)String.format(msg, operation.getSimpleName(), notFoundOClassesForOp.iterator().next()));
        }
        HashSet notFoundOps = new HashSet(expOperations.keySet());
        notFoundOps.removeAll(testedOps);
        if (!notFoundOps.isEmpty()) {
            msg = "Schema did not contain expected operation %s.";
            Assert.fail((String)String.format(msg, notFoundOps.iterator().next()));
        }
    }

    private void checkAttributeValues(ObjectClassInfo ocInfo, AttributeInfo attribute, Map<String, Object> expectedValues) {
        String msg = "Missing property definition for field '%s' of attribute '" + attribute.getName() + "' in object class " + ocInfo.getType();
        Assert.assertNotNull((String)String.format(msg, ATTRIBUTE_FIELD_TYPE), (Object)expectedValues.get(ATTRIBUTE_FIELD_TYPE));
        Assert.assertNotNull((String)String.format(msg, ATTRIBUTE_FILED_READABLE), (Object)expectedValues.get(ATTRIBUTE_FILED_READABLE));
        Assert.assertNotNull((String)String.format(msg, ATTRIBUTE_FIELD_CREATEABLE), (Object)expectedValues.get(ATTRIBUTE_FIELD_CREATEABLE));
        Assert.assertNotNull((String)String.format(msg, ATTRIBUTE_FIELD_UPDATEABLE), (Object)expectedValues.get(ATTRIBUTE_FIELD_UPDATEABLE));
        Assert.assertNotNull((String)String.format(msg, ATTRIBUTE_FIELD_REQUIRED), (Object)expectedValues.get(ATTRIBUTE_FIELD_REQUIRED));
        Assert.assertNotNull((String)String.format(msg, ATTRIBUTE_FIELD_MULTI_VALUE), (Object)expectedValues.get(ATTRIBUTE_FIELD_MULTI_VALUE));
        Assert.assertNotNull((String)String.format(msg, ATTRIBUTE_FIELD_RETURNED_BY_DEFAULT), (Object)expectedValues.get(ATTRIBUTE_FIELD_RETURNED_BY_DEFAULT));
        msg = "Object class '" + ocInfo.getType() + "', attribute '" + attribute.getName() + "': field '%s' expected value is '%s', but returned '%s'.";
        Assert.assertEquals((String)String.format(msg, ATTRIBUTE_FIELD_TYPE, expectedValues.get(ATTRIBUTE_FIELD_TYPE), attribute.getType().getName()), (Object)expectedValues.get(ATTRIBUTE_FIELD_TYPE), (Object)attribute.getType());
        Assert.assertEquals((String)String.format(msg, ATTRIBUTE_FILED_READABLE, expectedValues.get(ATTRIBUTE_FILED_READABLE), attribute.isReadable()), (Object)expectedValues.get(ATTRIBUTE_FILED_READABLE), (Object)attribute.isReadable());
        Assert.assertEquals((String)String.format(msg, ATTRIBUTE_FIELD_CREATEABLE, expectedValues.get(ATTRIBUTE_FIELD_CREATEABLE), attribute.isCreateable()), (Object)expectedValues.get(ATTRIBUTE_FIELD_CREATEABLE), (Object)attribute.isCreateable());
        Assert.assertEquals((String)String.format(msg, ATTRIBUTE_FIELD_UPDATEABLE, expectedValues.get(ATTRIBUTE_FIELD_UPDATEABLE), attribute.isUpdateable()), (Object)expectedValues.get(ATTRIBUTE_FIELD_UPDATEABLE), (Object)attribute.isUpdateable());
        Assert.assertEquals((String)String.format(msg, ATTRIBUTE_FIELD_REQUIRED, expectedValues.get(ATTRIBUTE_FIELD_REQUIRED), attribute.isRequired()), (Object)expectedValues.get(ATTRIBUTE_FIELD_REQUIRED), (Object)attribute.isRequired());
        Assert.assertEquals((String)String.format(msg, ATTRIBUTE_FIELD_MULTI_VALUE, expectedValues.get(ATTRIBUTE_FIELD_MULTI_VALUE), attribute.isMultiValued()), (Object)expectedValues.get(ATTRIBUTE_FIELD_MULTI_VALUE), (Object)attribute.isMultiValued());
        Assert.assertEquals((String)String.format(msg, ATTRIBUTE_FIELD_RETURNED_BY_DEFAULT, expectedValues.get(ATTRIBUTE_FIELD_RETURNED_BY_DEFAULT), attribute.isReturnedByDefault()), (Object)expectedValues.get(ATTRIBUTE_FIELD_RETURNED_BY_DEFAULT), (Object)attribute.isReturnedByDefault());
    }

    private Boolean getStrictCheckProperty() {
        Boolean strict = true;
        try {
            strict = (Boolean)SchemaApiOpTests.getDataProvider().getTestSuiteAttribute(STRICT_CHECK_PROPERTY_PREFIX, TEST_NAME);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return strict;
    }

    private Object getTestPropertyOrFail(String typeName, String propName, boolean failOnError) {
        Object propValue;
        block3: {
            propValue = null;
            try {
                propValue = SchemaApiOpTests.getDataProvider().getTestSuiteAttribute(propName, TEST_NAME);
            }
            catch (ObjectNotFoundException ex) {
                if (!failOnError) break block3;
                Assert.fail((String)("Property definition not found: " + ex.getMessage()));
            }
        }
        if (failOnError) {
            Assert.assertNotNull((Object)propValue);
        }
        return propValue;
    }

    static {
        opSupportedByAllOClasses.add(ScriptOnConnectorApiOp.class);
        opSupportedByAllOClasses.add(ScriptOnResourceApiOp.class);
        opSupportedByAllOClasses.add(TestApiOp.class);
        opSupportedByAllOClasses.add(ValidateApiOp.class);
    }
}

