/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashSet;
import java.util.Set;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.ResolveUsernameApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ResolveUsernameApiOpTests
extends ObjectClassRunner {
    private static final String TEST_NAME = "ResolveUsername";
    private static final String WRONG_USERNAME = "wrong.username";

    public ResolveUsernameApiOpTests(ObjectClass oclass) {
        super(oclass);
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }

    @Override
    public void testRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testPositive() {
        if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            return;
        }
        Uid uid = null;
        try {
            Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(ResolveUsernameApiOpTests.getDataProvider(), this.getObjectClassInfo(), "Authentication", 0, true, false);
            uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
            ConnectorObject obj = this.getConnectorFacade().getObject(this.getObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
            Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj);
            ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, attrs);
            String username = (String)ResolveUsernameApiOpTests.getDataProvider().getTestSuiteAttribute(this.getObjectClass().getObjectClassValue() + "." + "username", "Authentication");
            Uid result = this.getConnectorFacade().resolveUsername(this.getObjectClass(), username, null);
            Assert.assertEquals((Object)uid, (Object)result);
            if (uid == null) return;
        }
        catch (Throwable throwable) {
            if (uid == null) throw throwable;
            this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
            throw throwable;
        }
        this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
    }

    @Test
    public void testNegative() {
        if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            return;
        }
        String wrongUsername = null;
        try {
            wrongUsername = (String)ResolveUsernameApiOpTests.getDataProvider().getTestSuiteAttribute(WRONG_USERNAME, "Authentication");
        }
        catch (Exception ex) {
            wrongUsername = "unresolvableUsername";
        }
        try {
            this.getConnectorFacade().resolveUsername(this.getObjectClass(), wrongUsername, null);
            Assert.fail((String)("Runtime exception should be thrown when attempt to resolve non-existing user: '" + wrongUsername + "'"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> requiredOps = new HashSet<Class<? extends APIOperation>>();
        requiredOps.add(CreateApiOp.class);
        requiredOps.add(DeleteApiOp.class);
        requiredOps.add(ResolveUsernameApiOp.class);
        return requiredOps;
    }
}

