/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ContractException;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ContractTestBase;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class ObjectClassRunner
extends ContractTestBase {
    private static final Log LOG = Log.getLog(ObjectClassRunner.class);
    private final ObjectClass _objectClass;
    private ObjectClassInfo _objectClassInfo;
    private ObjectClass _supportedObjectClass;
    private boolean _ocSupported = false;

    public ObjectClassRunner(ObjectClass oclass) {
        this._objectClass = oclass;
    }

    @Override
    @Before
    public void init() {
        super.init();
        Set<Class<? extends APIOperation>> apiOps = this.getAPIOperations();
        Set oinfos = null;
        for (Class<? extends APIOperation> apiOperation : apiOps) {
            Set tmp;
            if (oinfos == null) {
                oinfos = this.getSchema().getSupportedObjectClassesByOperation(apiOperation);
                continue;
            }
            Set currOinfos = this.getSchema().getSupportedObjectClassesByOperation(apiOperation);
            oinfos = tmp = CollectionUtil.intersection((Collection)oinfos, (Collection)currOinfos);
        }
        for (ObjectClassInfo this._objectClassInfo : oinfos) {
            this._supportedObjectClass = ConnectorHelper.getObjectClassFromObjectClassInfo(this._objectClassInfo);
            if (!this._supportedObjectClass.equals((Object)this.getObjectClass())) continue;
            this._ocSupported = true;
            break;
        }
    }

    @Override
    @After
    public void dispose() {
        this._objectClassInfo = null;
        super.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testContract() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            try {
                LOG.info("--------------------------------------------------------------------------------------", new Object[0]);
                LOG.info("Running test ''{0}'' for object class ''{1}''.", new Object[]{this.getTestName(), this.getObjectClass()});
                LOG.info("--------------------------------------------------------------------------------------", new Object[0]);
                this.testRun();
                if (this.isObjectClassSupported()) return;
                Assert.fail((String)("ObjectClass " + this.getObjectClass() + " is not supported, must" + " throw RuntimeException"));
                return;
            }
            catch (RuntimeException e) {
                if (!this.isObjectClassSupported()) return;
                throw new ContractException("Unexpected RuntimeException thrown during contract test.", e);
            }
        } else {
            LOG.info("--------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''{0}'' for object class ''{1}''.", new Object[]{this.getTestName(), this.getObjectClass()});
            LOG.info("--------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    public abstract void testRun();

    @Parameterized.Parameters
    public static List<Object[]> data() {
        LinkedList<Object[]> oclasses = new LinkedList<Object[]>();
        List<String> objectClasses = ObjectClassRunner.getObjectClassesProperty();
        if (objectClasses != null) {
            for (String objectClass : objectClasses) {
                oclasses.add(new Object[]{new ObjectClass(objectClass)});
            }
        } else {
            Schema schema = ConnectorHelper.createConnectorFacade(ObjectClassRunner.getDataProvider()).schema();
            for (ObjectClassInfo ocInfo : schema.getObjectClassInfo()) {
                oclasses.add(new Object[]{ConnectorHelper.getObjectClassFromObjectClassInfo(ocInfo)});
            }
        }
        oclasses.add(new Object[]{new ObjectClass("NONEXISTING")});
        StringBuilder sb = new StringBuilder();
        for (Object[] oc : oclasses) {
            sb.append(oc[0].toString());
            sb.append(",");
        }
        LOG.info("Tested object classes will be: ''{0}''.", new Object[]{sb.toString()});
        return oclasses;
    }

    private static List<String> getObjectClassesProperty() {
        try {
            List objectClasses = (List)ObjectClassRunner.getDataProvider().getTestSuiteAttribute("objectClasses");
            return objectClasses;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public ObjectClass getObjectClass() {
        return this._objectClass;
    }

    public ObjectClass getSupportedObjectClass() {
        return this._supportedObjectClass;
    }

    public Schema getSchema() {
        return this.getConnectorFacade().schema();
    }

    public abstract String getTestName();

    public ObjectClassInfo getObjectClassInfo() {
        return this._objectClassInfo;
    }

    public boolean isObjectClassSupported() {
        return this._ocSupported;
    }

    @Override
    public OperationOptions getOperationOptionsByOp(Class<? extends APIOperation> clazz) {
        if (clazz.equals(SearchApiOp.class) || clazz.equals(GetApiOp.class) || clazz.equals(SyncApiOp.class)) {
            Set<String> readableAttrs = ConnectorHelper.getReadableAttributesNames(this.getObjectClassInfo());
            ArrayList<String> attrNames = new ArrayList<String>();
            for (AttributeInfo attrInfo : this.getObjectClassInfo().getAttributeInfo()) {
                if (!readableAttrs.contains(attrInfo.getName())) continue;
                attrNames.add(attrInfo.getName());
            }
            OperationOptionsBuilder opOptionsBuilder = new OperationOptionsBuilder();
            opOptionsBuilder.setAttributesToGet(attrNames);
            OperationOptions attrsToGet = opOptionsBuilder.build();
            return attrsToGet;
        }
        return super.getOperationOptionsByOp(clazz);
    }
}

