/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

public final class SQLParam {
    private String _name;
    private Object _value;
    private int _sqlType;
    private final String _quotedName;

    public SQLParam(String name, Object value, int sqlType) {
        this(name, value, sqlType, name);
    }

    public SQLParam(String name, Object value, int sqlType, String quotedName) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("SQL param name should be not null");
        }
        this._name = name;
        this._value = value;
        this._sqlType = sqlType;
        this._quotedName = quotedName;
    }

    public SQLParam(String name, Object value) {
        this(name, value, 0, name);
    }

    public String getQuotedName() {
        return this._quotedName;
    }

    public String getName() {
        return this._name;
    }

    public Object getValue() {
        return this._value;
    }

    public int getSqlType() {
        return this._sqlType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SQLParam other = (SQLParam)obj;
        return (this._name == other._name || this._name != null && this._name.equals(other._name)) && (this._value == other._value || this._value != null && this._value.equals(other._value)) && this._sqlType == other._sqlType;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this._name ? 0 : this._name.hashCode());
        hash = 31 * hash + (null == this._value ? 0 : this._value.hashCode());
        hash = 31 * hash + this._sqlType;
        return hash;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.getName() != null) {
            ret.append(this.getName());
            ret.append("=");
        }
        ret.append("\"" + this.getValue() + "\"");
        switch (this.getSqlType()) {
            case 2003: {
                ret.append(":[ARRAY]]");
                break;
            }
            case -5: {
                ret.append(":[BIGINT]");
                break;
            }
            case -2: {
                ret.append(":[BINARY]");
                break;
            }
            case -7: {
                ret.append(":[BIT]");
                break;
            }
            case 2004: {
                ret.append(":[BLOB]");
                break;
            }
            case 16: {
                ret.append(":[BOOLEAN]");
                break;
            }
            case 1: {
                ret.append(":[CHAR]");
                break;
            }
            case 2005: {
                ret.append(":[CLOB]");
                break;
            }
            case 70: {
                ret.append(":[DATALINK]");
                break;
            }
            case 91: {
                ret.append(":[DATE]");
                break;
            }
            case 3: {
                ret.append(":[DECIMAL]");
                break;
            }
            case 2001: {
                ret.append(":[DISTINCT]");
                break;
            }
            case 8: {
                ret.append(":[DOUBLE]");
                break;
            }
            case 6: {
                ret.append(":[FLOAT]");
                break;
            }
            case 4: {
                ret.append(":[INTEGER]");
                break;
            }
            case 2000: {
                ret.append(":[JAVA_OBJECT]");
                break;
            }
            case -4: {
                ret.append(":[LONGVARBINARY]");
                break;
            }
            case -1: {
                ret.append(":[LONGVARCHAR]");
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                ret.append(":[NUMERIC]");
                break;
            }
            case 1111: {
                ret.append(":[OTHER]");
                break;
            }
            case 7: {
                ret.append(":[REAL]");
                break;
            }
            case 2006: {
                ret.append(":[REF]");
                break;
            }
            case 5: {
                ret.append(":[SMALLINT]");
                break;
            }
            case 2002: {
                ret.append(":[STRUCT]");
                break;
            }
            case 92: {
                ret.append(":[TIME]");
                break;
            }
            case 93: {
                ret.append(":[TIMESTAMP]");
                break;
            }
            case -6: {
                ret.append(":[TINYINT]");
                break;
            }
            case -3: {
                ret.append(":[VARBINARY]");
                break;
            }
            case 12: {
                ret.append(":[VARCHAR]");
                break;
            }
            default: {
                ret.append(":[SQL Type:" + this.getSqlType() + "]");
            }
        }
        return ret.toString();
    }
}

