/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesResolver {
    private PropertiesResolver() {
    }

    public static Properties resolveProperties(Properties properties, Properties resolvedProperties) {
        if (properties == null) {
            return null;
        }
        return PropertiesResolver.resolveProperties(PropertiesResolver.copyProperties(properties), PropertiesResolver.copyProperties(resolvedProperties), new HashSet<String>(5));
    }

    public static Properties resolveProperties(Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties copy = PropertiesResolver.copyProperties(properties);
        return PropertiesResolver.resolveProperties(copy, new Properties(), new HashSet<String>(5));
    }

    private static Properties resolveProperties(Properties properties, Properties resolvedProperties, Set<String> justResolving) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String value = (String)entry.getValue();
            if (!value.contains("$")) continue;
            value = PropertiesResolver.resolveName((String)entry.getKey(), properties, resolvedProperties, justResolving);
            entry.setValue(value);
        }
        return properties;
    }

    private static String resolveName(String name, Properties properties, Properties resolvedProperties, Set<String> justResolving) {
        String value = null;
        if (!justResolving.isEmpty()) {
            value = resolvedProperties.getProperty(name);
        }
        if (value != null) {
            return value;
        }
        if (justResolving.contains(name)) {
            value = "RECURSION";
            return value;
        }
        value = properties.getProperty(name);
        if (value == null) {
            value = "NOT_RESOLVED";
            return value;
        }
        justResolving.add(name);
        value = PropertiesResolver.resolveValue(value, properties, resolvedProperties, justResolving);
        justResolving.remove(name);
        resolvedProperties.setProperty(name, value);
        return value;
    }

    private static String resolveValue(String value, Properties properties, Properties resolvedProperties, Set<String> justResolving) {
        if (value == null) {
            return null;
        }
        int index = 0;
        int length = value.length();
        StringBuilder result = new StringBuilder();
        while (index >= 0 && index < length) {
            int varStart = value.indexOf("${", index);
            if (varStart >= 0) {
                int varEnd = value.indexOf(125, varStart);
                if (varEnd >= 0) {
                    String varSubstring = value.substring(varStart, varEnd + 1);
                    String varName = varSubstring.substring(2, varSubstring.length() - 1);
                    String varValue = PropertiesResolver.resolveName(varName, properties, resolvedProperties, justResolving);
                    if ("NOT_RESOLVED".equals(varValue)) {
                        varValue = varSubstring;
                    } else if ("RECUSRION".equals(varValue)) {
                        varValue = "${RECURSION!!!_" + varName + "}";
                    }
                    result.append(value.substring(index, varStart));
                    result.append(varValue);
                    index = varEnd + 1;
                    continue;
                }
                result.append(value.substring(index, value.length()));
                index = value.length();
                continue;
            }
            result.append(value.substring(index, value.length()));
            index = value.length();
        }
        return result.toString();
    }

    private static Properties copyProperties(Properties properties) {
        Properties result = new Properties();
        if (properties == null) {
            return result;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

