/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

import org.identityconnectors.framework.common.objects.ConnectorMessages;

public class LocalizedAssert {
    private ConnectorMessages cm;
    private boolean localizeArguments;

    public LocalizedAssert(ConnectorMessages cm) {
        if (cm == null) {
            throw new IllegalArgumentException("ConnectorMessages argument is null");
        }
        this.cm = cm;
    }

    public LocalizedAssert(ConnectorMessages cm, boolean localizeArguments) {
        if (cm == null) {
            throw new IllegalArgumentException("ConnectorMessages argument is null");
        }
        this.cm = cm;
        this.localizeArguments = localizeArguments;
    }

    private void throwException(String locKey, String argument) {
        if (this.localizeArguments) {
            argument = this.cm.format(argument, argument, new Object[0]);
        }
        String msg = this.cm.format(locKey, null, new Object[]{argument});
        throw new IllegalArgumentException(msg);
    }

    public <T> T assertNotNull(T o, String argument) {
        if (o == null) {
            this.throwException("assert.notNull", argument);
        }
        return o;
    }

    public <T> T assertNull(T o, String argument) {
        if (o != null) {
            this.throwException("assert.null", argument);
        }
        return o;
    }

    public String assertNotBlank(String o, String argument) {
        if (o == null || o.length() == 0) {
            this.throwException("assert.notBlank", argument);
        }
        return o;
    }

    public String assertBlank(String s, String argument) {
        if (s != null && s.length() > 0) {
            this.throwException("assert.blank", argument);
        }
        return s;
    }
}

