/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

import java.util.Hashtable;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.ConnectorMessages;

public abstract class JNDIUtil {
    public static final String INVALID_JNDI_ENTRY = "invalid.jndi.entry";

    private JNDIUtil() {
    }

    public static Hashtable<String, String> arrayToHashtable(String[] entries, ConnectorMessages messages) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (entries != null) {
            for (String entry : entries) {
                if (!StringUtil.isNotBlank((String)entry)) continue;
                int firstEq = entry.indexOf(61);
                if (firstEq == -1) {
                    JNDIUtil.throwFormatException(messages, entry, "Invalid value in JNDI entry");
                }
                if (firstEq == 0) {
                    JNDIUtil.throwFormatException(messages, entry, "First character cannot be =");
                }
                String key = entry.substring(0, firstEq);
                String value = firstEq == entry.length() - 1 ? null : entry.substring(firstEq + 1);
                result.put(key, value);
            }
        }
        return result;
    }

    private static void throwFormatException(ConnectorMessages messages, String entry, String defaultMsg) {
        String msg = null;
        msg = messages == null ? defaultMsg + " : " + entry : messages.format(INVALID_JNDI_ENTRY, "invalid.jndi.entry : " + entry, new Object[]{entry});
        throw new IllegalArgumentException(msg);
    }
}

