/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

import java.util.ArrayList;
import java.util.List;
import org.connid.bundles.db.common.SQLParam;
import org.identityconnectors.common.CollectionUtil;

public class FilterWhereBuilder {
    private boolean in;
    private List<SQLParam> params = new ArrayList<SQLParam>();
    private StringBuilder where = new StringBuilder();

    public void join(String operator, FilterWhereBuilder l, FilterWhereBuilder r) {
        this.in = true;
        if (l.isIn()) {
            this.where.append("( ");
        }
        this.where.append((CharSequence)l.getWhere());
        if (l.isIn()) {
            this.where.append(" )");
        }
        this.where.append(" ");
        this.where.append(operator);
        this.where.append(" ");
        if (r.isIn()) {
            this.where.append("( ");
        }
        this.where.append((CharSequence)r.getWhere());
        if (r.isIn()) {
            this.where.append(" )");
        }
        this.params.addAll(l.getParams());
        this.params.addAll(r.getParams());
    }

    public List<SQLParam> getParams() {
        return CollectionUtil.asReadOnlyList(this.params);
    }

    public StringBuilder getWhere() {
        return this.where;
    }

    public void addBind(SQLParam param, String operator) {
        if (param == null) {
            throw new IllegalArgumentException("null.param.not.suported");
        }
        this.where.append(param.getQuotedName());
        this.where.append(" ").append(operator).append(" ?");
        this.params.add(param);
    }

    public void addNull(String name) {
        this.where.append(name);
        this.where.append(" IS NULL");
    }

    public boolean isIn() {
        return this.in;
    }

    public String getWhereClause() {
        return this.getWhere().toString();
    }
}

