/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.connid.bundles.db.common.FilterWhereBuilder;
import org.connid.bundles.db.common.SQLParam;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.StringUtil;

public class DatabaseQueryBuilder {
    private String selectFrom = null;
    private String tableName = null;
    private FilterWhereBuilder where = null;
    private Set<String> columns = new HashSet<String>();
    private List<OrderBy> orderBy = null;

    public void setColumns(Set<String> columns) {
        this.columns = columns;
    }

    public void setSelectFrom(String selectFrom) {
        this.selectFrom = selectFrom;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setWhere(FilterWhereBuilder whereBuilder) {
        this.where = whereBuilder;
    }

    public void setOrderBy(List<OrderBy> orderBy) {
        this.orderBy = orderBy;
    }

    public DatabaseQueryBuilder(String tableName, Set<String> columns) {
        if (StringUtil.isBlank((String)tableName)) {
            throw new IllegalArgumentException("the tableName must not be null or empty");
        }
        if (columns == null || columns.size() == 0) {
            throw new IllegalArgumentException("CoulmnNamesToGet must not be empty");
        }
        this.tableName = tableName;
        this.columns = columns;
    }

    public DatabaseQueryBuilder(String selectFrom) {
        if (StringUtil.isBlank((String)selectFrom)) {
            throw new IllegalArgumentException("the selectFrom clause must not be empty");
        }
        this.selectFrom = selectFrom;
    }

    public String getSQL() {
        String whereSql;
        if (StringUtil.isBlank((String)this.selectFrom)) {
            if (StringUtil.isBlank((String)this.tableName)) {
                throw new IllegalArgumentException("the tableName must not be null or empty");
            }
            if (this.columns != null) {
                this.selectFrom = this.createSelect(this.columns);
            }
            if (StringUtil.isBlank((String)this.selectFrom)) {
                throw new IllegalArgumentException("the selectFrom clause must not be empty");
            }
        } else {
            if (!this.selectFrom.toUpperCase().contains("SELECT")) {
                throw new IllegalArgumentException("the required SELECt clause is missing");
            }
            if (!this.selectFrom.toUpperCase().contains("FROM")) {
                throw new IllegalArgumentException("the required FROM clause is missing");
            }
        }
        String ret = this.selectFrom;
        if (this.where != null && !StringUtil.isBlank((String)(whereSql = this.where.getWhereClause()))) {
            ret = this.whereAnd(this.selectFrom, whereSql);
        }
        if (this.orderBy != null) {
            StringBuilder obld = new StringBuilder(" ORDER BY ");
            boolean first = true;
            for (OrderBy ord : this.orderBy) {
                if (!first) {
                    obld.append(", ");
                }
                first = false;
                obld.append(ord.getColumnName());
                obld.append(ord.isAscendent() ? " ASC" : " DESC");
            }
            if (obld.length() != 0) {
                ret = ret + obld.toString();
            }
        }
        return ret;
    }

    private String whereAnd(String sqlSelect, String whereAnd) {
        int iofw = sqlSelect.indexOf("WHERE");
        return iofw == -1 ? sqlSelect + " WHERE " + whereAnd : sqlSelect.substring(0, iofw) + "WHERE (" + sqlSelect.substring(iofw + 5) + ") AND ( " + whereAnd + " )";
    }

    private String createSelect(Set<String> columnNamesToGet) {
        if (columnNamesToGet.size() == 0) {
            throw new IllegalStateException("No coulmnNamesToGet");
        }
        StringBuilder ret = new StringBuilder("SELECT ");
        boolean first = true;
        for (String name : columnNamesToGet) {
            if (!first) {
                ret.append(", ");
            }
            ret.append(name);
            ret.append(" ");
            first = false;
        }
        ret.append("FROM ");
        ret.append(this.tableName);
        return ret.toString();
    }

    public List<SQLParam> getParams() {
        if (this.where == null) {
            return new ArrayList<SQLParam>();
        }
        return this.where.getParams();
    }

    public static class OrderBy
    extends Pair<String, Boolean> {
        public OrderBy(String columnName, Boolean asc) {
            super((Object)columnName, (Object)asc);
        }

        public String getColumnName() {
            return (String)this.first;
        }

        public boolean isAscendent() {
            return (Boolean)this.second;
        }
    }
}

