/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

import org.connid.bundles.db.common.FilterWhereBuilder;
import org.connid.bundles.db.common.SQLParam;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public abstract class DatabaseFilterTranslator
extends AbstractFilterTranslator<FilterWhereBuilder> {
    ObjectClass oclass;
    OperationOptions options;

    public DatabaseFilterTranslator(ObjectClass oclass, OperationOptions options) {
        this.oclass = oclass;
        this.options = options;
    }

    protected FilterWhereBuilder createBuilder() {
        return new FilterWhereBuilder();
    }

    protected FilterWhereBuilder createAndExpression(FilterWhereBuilder leftExpression, FilterWhereBuilder rightExpression) {
        FilterWhereBuilder build = this.createBuilder();
        build.join("AND", leftExpression, rightExpression);
        return build;
    }

    protected FilterWhereBuilder createOrExpression(FilterWhereBuilder leftExpression, FilterWhereBuilder rightExpression) {
        FilterWhereBuilder build = this.createBuilder();
        build.join("OR", leftExpression, rightExpression);
        return build;
    }

    protected FilterWhereBuilder createEqualsExpression(EqualsFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        if (not) {
            ret.getWhere().append("NOT ");
        }
        if (param.getValue() == null) {
            ret.addNull(param.getName());
            return ret;
        }
        ret.addBind(param, "=");
        return ret;
    }

    protected FilterWhereBuilder createContainsExpression(ContainsFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null || param.getValue() == null || !(param.getValue() instanceof String)) {
            return null;
        }
        String value = (String)param.getValue();
        FilterWhereBuilder ret = this.createBuilder();
        if (not) {
            ret.getWhere().append("NOT ");
        }
        if (!value.startsWith("%")) {
            value = "%" + value;
        }
        if (!value.endsWith("%")) {
            value = value + "%";
        }
        ret.addBind(new SQLParam(param.getName(), value, param.getSqlType()), "LIKE");
        return ret;
    }

    protected FilterWhereBuilder createEndsWithExpression(EndsWithFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null || param.getValue() == null || !(param.getValue() instanceof String)) {
            return null;
        }
        String value = (String)param.getValue();
        FilterWhereBuilder ret = this.createBuilder();
        if (not) {
            ret.getWhere().append("NOT ");
        }
        if (!value.startsWith("%")) {
            value = "%" + value;
        }
        ret.addBind(new SQLParam(param.getName(), value, param.getSqlType()), "LIKE");
        return ret;
    }

    protected FilterWhereBuilder createStartsWithExpression(StartsWithFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null || param.getValue() == null || !(param.getValue() instanceof String)) {
            return null;
        }
        String value = (String)param.getValue();
        FilterWhereBuilder ret = this.createBuilder();
        if (not) {
            ret.getWhere().append("NOT ");
        }
        if (!value.endsWith("%")) {
            value = value + "%";
        }
        ret.addBind(new SQLParam(param.getName(), value, param.getSqlType()), "LIKE");
        return ret;
    }

    protected FilterWhereBuilder createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null || param.getValue() == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        String op = not ? "<=" : ">";
        ret.addBind(param, op);
        return ret;
    }

    protected FilterWhereBuilder createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null || param.getValue() == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        String op = not ? "<" : ">=";
        ret.addBind(param, op);
        return ret;
    }

    protected FilterWhereBuilder createLessThanExpression(LessThanFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null || param.getValue() == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        String op = not ? ">=" : "<";
        ret.addBind(param, op);
        return ret;
    }

    protected FilterWhereBuilder createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam param = this.getSQLParam(attribute, this.oclass, this.options);
        if (param == null || param.getValue() == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        String op = not ? ">" : "<=";
        ret.addBind(param, op);
        return ret;
    }

    protected abstract SQLParam getSQLParam(Attribute var1, ObjectClass var2, OperationOptions var3);

    protected boolean validateSearchAttribute(Attribute attribute) {
        return !byte[].class.equals(AttributeUtil.getSingleValue((Attribute)attribute).getClass());
    }
}

