/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.db.common;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.connid.bundles.db.common.DatabaseQueryBuilder;
import org.connid.bundles.db.common.SQLParam;
import org.connid.bundles.db.common.SQLUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class DatabaseConnection {
    private static final Log log = Log.getLog(DatabaseConnection.class);
    private Connection nativeConn = null;

    DatabaseConnection() {
    }

    public DatabaseConnection(Connection conn) {
        this.nativeConn = conn;
    }

    public void dispose() {
        SQLUtil.closeQuietly(this.nativeConn);
    }

    public void test() {
        try {
            this.getConnection().setAutoCommit(!this.getConnection().getAutoCommit());
            this.getConnection().setAutoCommit(!this.getConnection().getAutoCommit());
            this.commit();
            log.ok("connection tested", new Object[0]);
        }
        catch (Exception e) {
            SQLUtil.rollbackQuietly(this.getConnection());
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.nativeConn;
    }

    public void setConnection(Connection connection) {
        this.nativeConn = connection;
    }

    public PreparedStatement prepareStatement(String sql, List<SQLParam> params) throws SQLException {
        log.ok("prepareStatement: statement {0}", new Object[]{sql});
        ArrayList<SQLParam> out = new ArrayList<SQLParam>();
        String nomalized = SQLUtil.normalizeNullValues(sql, params, out);
        PreparedStatement prepareStatement = this.getConnection().prepareStatement(nomalized);
        SQLUtil.setParams(prepareStatement, out);
        log.ok("prepareStatement: normalizzed statement {0} prepared", new Object[]{nomalized});
        return prepareStatement;
    }

    public PreparedStatement prepareStatement(DatabaseQueryBuilder query) throws SQLException {
        String sql = query.getSQL();
        log.ok("prepareStatement {0}", new Object[]{sql});
        return this.prepareStatement(sql, query.getParams());
    }

    public CallableStatement prepareCall(String sql, List<SQLParam> params) throws SQLException {
        log.ok("normalize call statement {0}", new Object[]{sql});
        ArrayList<SQLParam> out = new ArrayList<SQLParam>();
        String nomalized = SQLUtil.normalizeNullValues(sql, params, out);
        CallableStatement prepareCall = this.getConnection().prepareCall(nomalized);
        SQLUtil.setParams(prepareCall, out);
        log.ok("call statement {0} normalizead and prepared", new Object[]{nomalized});
        return prepareCall;
    }

    public void commit() {
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            SQLUtil.rollbackQuietly(this.getConnection());
            log.error((Throwable)e, "error in commit", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }
}

