/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.DriverManagerType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.concordion.cubano.driver.web.config.WebDriverConfig;
import org.concordion.cubano.driver.web.provider.LocalBrowserProvider;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromeBrowserProvider
extends LocalBrowserProvider {
    public static final String BROWSER_NAME = "chrome";

    @Override
    protected String getBrowserName() {
        return BROWSER_NAME;
    }

    public WebDriver createDriver() {
        this.setupBrowserManager(ChromeDriverManager.getInstance((DriverManagerType)DriverManagerType.CHROME));
        ChromeOptions options = new ChromeOptions();
        this.addProxyCapabilities((MutableCapabilities)options);
        if (!this.getBrowserExe().isEmpty()) {
            options.setBinary(this.getBrowserExe());
        }
        this.setBrowserSizeAndLocation(options);
        this.addCapabilities(options);
        this.addArguments(options);
        this.addOptions(options);
        this.addPreferences(options);
        this.addExtensions(options);
        ChromeDriver driver = new ChromeDriver(options);
        return driver;
    }

    private void setBrowserSizeAndLocation(ChromeOptions options) {
        WebDriverConfig config = WebDriverConfig.getInstance();
        if (config.isBrowserMaximized()) {
            options.addArguments(new String[]{"start-maximized"});
        } else {
            if (!config.getBrowserDimension().isEmpty()) {
                options.addArguments(new String[]{"window-size=" + config.getBrowserDimension().replace("x", ",")});
            }
            if (!config.getBrowserPosition().isEmpty()) {
                options.addArguments(new String[]{"window-position=" + config.getBrowserPosition().replace("x", ",")});
            }
        }
    }

    private void addArguments(ChromeOptions options) {
        Map<String, String> settings = this.getPropertiesStartingWith("argument.");
        for (String key : settings.keySet()) {
            options.addArguments(new String[]{settings.get(key)});
        }
    }

    private void addCapabilities(ChromeOptions options) {
        Map<String, String> settings = this.getPropertiesStartingWith("capability.");
        for (String key : settings.keySet()) {
            options.setCapability(key, this.toObject(settings.get(key)));
        }
    }

    private void addOptions(ChromeOptions options) {
        Map<String, String> settings = this.getPropertiesStartingWith("option.");
        for (String key : settings.keySet()) {
            options.setExperimentalOption(key, this.toObject(settings.get(key)));
        }
    }

    private void addPreferences(ChromeOptions options) {
        Map<String, String> settings = this.getPropertiesStartingWith("preference.");
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        for (String key : settings.keySet()) {
            prefs.put(key, this.toObject(settings.get(key)));
        }
        if (!prefs.isEmpty()) {
            options.setExperimentalOption("prefs", prefs);
        }
    }

    private void addExtensions(ChromeOptions options) {
        Map<String, String> settings = this.getPropertiesStartingWith("extension.");
        String projectPath = new File("").getAbsolutePath();
        for (String key : settings.keySet()) {
            String extension = settings.get(key);
            extension = extension.replace("%PROJECT%", projectPath);
            options.addExtensions(new File[]{new File(extension)});
        }
    }
}

