/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import java.util.Map;
import org.concordion.cubano.driver.web.provider.LocalBrowserProvider;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;

public class InternetExplorerBrowserProvider
extends LocalBrowserProvider {
    public static final String BROWSER_NAME = "ie";

    @Override
    protected String getBrowserName() {
        return BROWSER_NAME;
    }

    public WebDriver createDriver() {
        this.setupBrowserManager(InternetExplorerDriverManager.getInstance());
        InternetExplorerOptions options = new InternetExplorerOptions();
        this.addProxyCapabilities((MutableCapabilities)options);
        this.addRecommendedDefaultCapabilities(options);
        this.addCapabilities(options);
        InternetExplorerDriver driver = new InternetExplorerDriver(options);
        this.setBrowserSizeAndLocation((WebDriver)driver);
        return driver;
    }

    private void addCapabilities(InternetExplorerOptions options) {
        Map<String, String> settings = this.getPropertiesStartingWith("capability.");
        for (String key : settings.keySet()) {
            options.setCapability(key, this.toObject(settings.get(key)));
        }
    }

    private void addRecommendedDefaultCapabilities(InternetExplorerOptions options) {
        options.setCapability("ignoreZoomSetting", true);
        options.setCapability("nativeEvents", false);
        options.setCapability("requireWindowFocus", false);
        options.setCapability("takesScreenshot", true);
        options.setCapability("javascriptEnabled", true);
    }
}

