/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import io.github.bonigarcia.wdm.FirefoxDriverManager;
import java.io.File;
import java.util.Map;
import org.concordion.cubano.driver.web.provider.LocalBrowserProvider;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;

public class FirefoxBrowserProvider
extends LocalBrowserProvider {
    public static final String BROWSER_NAME = "firefox";

    @Override
    protected String getBrowserName() {
        return BROWSER_NAME;
    }

    public WebDriver createDriver() {
        String profileName;
        boolean useLegacyDriver = this.getPropertyAsBoolean("useLegacyDriver", "false");
        if (!useLegacyDriver) {
            this.setupBrowserManager(FirefoxDriverManager.getInstance());
        }
        FirefoxOptions options = new FirefoxOptions();
        options.setLegacy(useLegacyDriver);
        this.addProxyCapabilities((MutableCapabilities)options);
        if (!this.getBrowserExe().isEmpty()) {
            options.setBinary(this.getBrowserExe());
        }
        if (!(profileName = this.getProperty("profile", "")).equalsIgnoreCase("none")) {
            FirefoxProfile profile;
            if (profileName.isEmpty()) {
                profile = new FirefoxProfile();
            } else {
                profile = new ProfilesIni().getProfile(profileName);
                if (profile == null) {
                    File folder = new File(profileName);
                    if (folder.exists() && folder.isDirectory()) {
                        profile = new FirefoxProfile(folder);
                    } else {
                        throw new InvalidArgumentException(profileName + " does not match an existing Firefox profile or folder");
                    }
                }
            }
            this.addProfileProperties(profile);
            this.addExtensions(profile);
            options.setProfile(profile);
        }
        this.addCapabilities(options);
        this.stopLogging();
        FirefoxDriver driver = new FirefoxDriver(options);
        this.setBrowserSizeAndLocation((WebDriver)driver);
        return driver;
    }

    private void stopLogging() {
        if (this.getPropertyAsBoolean("disable.logs", "true")) {
            String osNullOutput = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? "NUL" : "/dev/null";
            System.setProperty("webdriver.firefox.logfile", osNullOutput);
        }
    }

    @Override
    protected void addProxyCapabilities(MutableCapabilities capabilities) {
        if (this.getPropertyAsBoolean("useLegacyDriver", "false")) {
            super.addProxyCapabilities(capabilities);
        }
    }

    private void addProfileProperties(FirefoxProfile profile) {
        Map<String, String> properties = this.getPropertiesStartingWith("profile.");
        profile.setPreference("app.update.auto", false);
        profile.setPreference("app.update.enabled", false);
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            Class<?> valueClass = this.getClassOfValue(value);
            if (valueClass == Boolean.class) {
                profile.setPreference(key, Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (valueClass == Integer.TYPE) {
                profile.setPreference(key, Integer.valueOf(value).intValue());
                continue;
            }
            profile.setPreference(key, properties.get(key));
        }
    }

    private void addCapabilities(FirefoxOptions options) {
        Map<String, String> properties = this.getPropertiesStartingWith("capability.");
        for (String key : properties.keySet()) {
            options.setCapability(key, this.toObject(properties.get(key)));
        }
    }

    private void addExtensions(FirefoxProfile profile) {
        Map<String, String> settings = this.getPropertiesStartingWith("extension.");
        String projectPath = new File("").getAbsolutePath();
        for (String key : settings.keySet()) {
            String extension = settings.get(key);
            extension = extension.replace("%PROJECT%", projectPath);
            try {
                profile.addExtension(new File(extension));
                if (!extension.contains("firebug")) continue;
                String version = new File(extension).getName();
                version = version.substring(0, (version = version.substring(version.indexOf("-") + 1)).indexOf("-") > 0 ? version.indexOf("-") : version.indexOf("."));
                profile.setPreference("extensions.firebug.currentVersion", version);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to add FireFox plugins", e);
            }
        }
    }
}

