/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public enum CheckForUpdates {
    ALWAYS,
    HOURLY,
    DAILY,
    WEEKLY,
    MONTHLY,
    NEVER;

    private ChronoUnit unit;

    public boolean recheckIsRequired(Date fromDate) {
        switch (this) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        Instant now = Instant.now();
        Instant nextCheck = Instant.ofEpochMilli(fromDate.getTime()).plus(1L, this.unit);
        return nextCheck.isBefore(now);
    }

    static {
        CheckForUpdates.HOURLY.unit = ChronoUnit.HOURS;
        CheckForUpdates.DAILY.unit = ChronoUnit.DAYS;
        CheckForUpdates.DAILY.unit = ChronoUnit.DAYS;
        CheckForUpdates.WEEKLY.unit = ChronoUnit.WEEKS;
        CheckForUpdates.MONTHLY.unit = ChronoUnit.MONTHS;
    }
}

