/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta.transaction.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.LockObtainFailedException;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.TransactionProcessor;
import org.compass.core.lucene.engine.transaction.TransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJobs;
import org.compass.core.transaction.context.TransactionContextCallback;
import org.compass.core.util.StringUtils;
import org.compass.needle.terracotta.transaction.processor.TerracottaHolder;
import org.compass.needle.terracotta.transaction.processor.TerracottaTransactionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaTransactionProcessorFactory
implements TransactionProcessorFactory,
CompassConfigurable,
SearchEngineFactoryAware {
    private static final transient Log logger = LogFactory.getLog(TerracottaTransactionProcessorFactory.class);
    private final TerracottaHolder holder = new TerracottaHolder();
    private transient LuceneSearchEngineFactory searchEngineFactory;
    private transient CompassSettings settings;
    private final transient Map<String, TerracottaProcessor> currentProcessors = new ConcurrentHashMap<String, TerracottaProcessor>();
    private int batchJobsSize;
    private long batchJobTimeout;
    private int nonBlockingBatchSize;

    @Override
    public void setSearchEngineFactory(SearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = (LuceneSearchEngineFactory)searchEngineFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
        this.batchJobsSize = settings.getSettingAsInt("compass.transaction.processor.tc.batchJobSize", 5);
        this.batchJobTimeout = settings.getSettingAsTimeInMillis("compass.transaction.processor.tc.batchJobSize", 100L);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Terracotta Transaction Processor blocking batch size is [" + this.batchJobsSize + "] with timeout of [" + this.batchJobTimeout + "ms]"));
        }
        this.nonBlockingBatchSize = settings.getSettingAsInt("compass.transaction.processor.tc.nonBlockingBatchJobSize", 5);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Terracotta Transaction Processor non blocking batch size is [" + this.nonBlockingBatchSize + "]"));
        }
        this.holder.getInitializationLock().lock();
        try {
            for (String subIndex : this.searchEngineFactory.getIndexManager().getSubIndexes()) {
                Lock processorLock;
                BlockingQueue<TransactionJobs> subIndexJobs = this.holder.getJobsPerSubIndex().get(subIndex);
                if (subIndexJobs == null) {
                    subIndexJobs = new LinkedBlockingQueue<TransactionJobs>();
                    this.holder.getJobsPerSubIndex().put(subIndex, subIndexJobs);
                }
                if ((processorLock = this.holder.getProcessorLocks().get(subIndex)) != null) continue;
                processorLock = new ReentrantLock();
                this.holder.getProcessorLocks().put(subIndex, processorLock);
            }
        }
        finally {
            this.holder.getInitializationLock().unlock();
        }
        if (settings.getSettingAsBoolean("compass.transaction.processor.tc.process", true)) {
            String[] aliasesSetting;
            String[] subIndexesSetting = StringUtils.commaDelimitedListToStringArray(settings.getSetting("compass.transaction.processor.tc.subIndexes"));
            if (subIndexesSetting.length == 0) {
                subIndexesSetting = null;
            }
            if ((aliasesSetting = StringUtils.commaDelimitedListToStringArray(settings.getSetting("compass.transaction.processor.tc.aliases"))).length == 0) {
                aliasesSetting = null;
            }
            Object[] subIndexes = this.searchEngineFactory.getIndexManager().calcSubIndexes(subIndexesSetting, aliasesSetting, null);
            logger.info((Object)("Terracotta Transaction Processor Worker started. Sub indexes to process: " + Arrays.toString(subIndexes)));
            for (Object subIndex : subIndexes) {
                TerracottaProcessor processor = new TerracottaProcessor((String)subIndex, this.holder.getJobsPerSubIndex().get(subIndex));
                this.searchEngineFactory.getExecutorManager().submit(processor);
                this.currentProcessors.put((String)subIndex, processor);
            }
        } else {
            logger.info((Object)"Terracotta transaction processor will only submit transactions to be processed (none worker mode)");
        }
    }

    @Override
    public TransactionProcessor create(LuceneSearchEngine searchEngine) {
        return new TerracottaTransactionProcessor(searchEngine, this);
    }

    @Override
    public void close() {
        for (TerracottaProcessor processor : this.currentProcessors.values()) {
            processor.stop();
        }
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    public Map<String, TransactionJobs> add(TransactionJobs jobs) {
        Map<String, TransactionJobs> subIndexesJobs = jobs.buildJobsPerSubIndex();
        for (Map.Entry<String, TransactionJobs> entry : subIndexesJobs.entrySet()) {
            this.holder.getJobsPerSubIndex().get(entry.getKey()).add(entry.getValue());
        }
        return subIndexesJobs;
    }

    public void remove(Map<String, TransactionJobs> subIndexesJobs) {
        for (Map.Entry<String, TransactionJobs> entry : subIndexesJobs.entrySet()) {
            this.holder.getJobsPerSubIndex().get(entry.getKey()).remove(entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TerracottaProcessor
    implements Runnable {
        private final BlockingQueue<TransactionJobs> jobsToProcess;
        private final String subIndex;
        private volatile boolean running = true;

        private TerracottaProcessor(String subIndex, BlockingQueue<TransactionJobs> jobsToProcess) {
            this.subIndex = subIndex;
            this.jobsToProcess = jobsToProcess;
        }

        public String getSubIndex() {
            return this.subIndex;
        }

        public void stop() {
            this.running = false;
        }

        private String message(String message) {
            return "Processor [" + this.subIndex + "]: " + message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                Lock processLock = TerracottaTransactionProcessorFactory.this.holder.getProcessorLocks().get(this.subIndex);
                boolean locked = false;
                try {
                    locked = processLock.tryLock(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
                if (!locked) continue;
                try {
                    TransactionJobs jobs = null;
                    try {
                        jobs = this.jobsToProcess.poll(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        this.running = false;
                    }
                    if (jobs == null) continue;
                    final ArrayList<TransactionJobs> jobsList = new ArrayList<TransactionJobs>();
                    jobsList.add(jobs);
                    for (int i = 0; i < TerracottaTransactionProcessorFactory.this.batchJobsSize; ++i) {
                        try {
                            jobs = this.jobsToProcess.poll(TerracottaTransactionProcessorFactory.this.batchJobTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            this.running = false;
                        }
                        if (jobs == null) break;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Batching additional Jobs [" + System.identityHashCode(jobs) + "]"));
                        }
                        jobsList.add(jobs);
                    }
                    this.jobsToProcess.drainTo(jobsList, TerracottaTransactionProcessorFactory.this.nonBlockingBatchSize);
                    if (logger.isDebugEnabled()) {
                        int totalJobs = 0;
                        for (TransactionJobs x : jobsList) {
                            totalJobs += x.getJobs().size();
                        }
                        logger.debug((Object)this.message("procesing [" + jobsList.size() + "] transactions with [" + totalJobs + "] jobs"));
                    }
                    final TransactionJobs finalJobs = jobs;
                    TerracottaTransactionProcessorFactory.this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public Boolean doInTransaction() throws CompassException {
                            IndexWriter writer;
                            try {
                                writer = TerracottaTransactionProcessorFactory.this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().openIndexWriter(TerracottaTransactionProcessorFactory.this.settings, TerracottaProcessor.this.subIndex);
                                TerracottaTransactionProcessorFactory.this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().trackOpenIndexWriter(TerracottaProcessor.this.subIndex, writer);
                            }
                            catch (LockObtainFailedException e) {
                                logger.error((Object)TerracottaProcessor.this.message("Another instance is running on the sub index, make sure it does not. Should not happen really..."));
                                return false;
                            }
                            catch (IOException e) {
                                logger.error((Object)TerracottaProcessor.this.message("Failed to open index writer, dismissing jobs [" + finalJobs + "]. Should not happen really..."), (Throwable)e);
                                return false;
                            }
                            try {
                                for (TransactionJobs xJobs : jobsList) {
                                    for (TransactionJob job : xJobs.getJobs()) {
                                        job.execute(writer, TerracottaTransactionProcessorFactory.this.searchEngineFactory);
                                    }
                                }
                                writer.commit();
                                return null;
                            }
                            catch (Exception e) {
                                logger.error((Object)TerracottaProcessor.this.message("Failed to process jobs [" + finalJobs + "]"), (Throwable)e);
                                try {
                                    writer.rollback();
                                    return null;
                                }
                                catch (IOException e1) {
                                    logger.warn((Object)TerracottaProcessor.this.message("Failed to rollback transaction on jobs [" + finalJobs + "]"), (Throwable)e);
                                    return null;
                                }
                            }
                            finally {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    logger.warn((Object)TerracottaProcessor.this.message("Failed to close writer, ignoring"), (Throwable)e);
                                }
                                finally {
                                    TerracottaTransactionProcessorFactory.this.searchEngineFactory.getLuceneIndexManager().getIndexWritersManager().trackCloseIndexWriter(TerracottaProcessor.this.subIndex, writer);
                                }
                            }
                        }
                    });
                }
                finally {
                    processLock.unlock();
                }
            }
        }
    }
}

